/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public final class NetconfMessageUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfMessageUtil.class);

    private NetconfMessageUtil() {
    }

    public static boolean isOKMessage(NetconfMessage message) {
        return NetconfMessageUtil.isOKMessage(message.getDocument());
    }

    public static boolean isOKMessage(Document document) {
        return NetconfMessageUtil.isOKMessage(XmlElement.fromDomDocument((Document)document));
    }

    public static boolean isOKMessage(XmlElement xmlElement) {
        List children = xmlElement.getChildElements();
        return children.size() == 1 && ((XmlElement)children.get(0)).getName().equals("ok");
    }

    public static boolean isErrorMessage(NetconfMessage message) {
        return NetconfMessageUtil.isErrorMessage(message.getDocument());
    }

    public static boolean isErrorMessage(Document document) {
        return NetconfMessageUtil.isErrorMessage(XmlElement.fromDomDocument((Document)document));
    }

    public static boolean isErrorMessage(XmlElement xmlElement) {
        return xmlElement.getChildElements().stream().anyMatch(result -> "rpc-error".equals(result.getName()));
    }

    public static Collection<String> extractCapabilitiesFromHello(Document doc) {
        XmlElement responseElement = XmlElement.fromDomDocument((Document)doc);
        Optional capabilitiesElement = responseElement.getOnlyChildElementWithSameNamespaceOptionally("capabilities");
        if (capabilitiesElement.isEmpty()) {
            capabilitiesElement = responseElement.getOnlyChildElementOptionally("capabilities");
        }
        List caps = ((XmlElement)capabilitiesElement.orElseThrow()).getChildElements("capability");
        return Collections2.transform((Collection)caps, input -> {
            try {
                return input.getTextContent().trim();
            }
            catch (DocumentedException e) {
                LOG.trace("Error fetching input text content", (Throwable)e);
                return null;
            }
        });
    }
}

