/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import com.google.common.collect.ImmutableSet;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Promise;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.index.qual.NonNegative;
import org.opendaylight.netconf.api.messages.HelloMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiator;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.nettyutil.NetconfSessionNegotiator;
import org.opendaylight.netconf.nettyutil.handler.exi.EXIParameters;
import org.opendaylight.netconf.nettyutil.handler.exi.NetconfStartExiMessageProvider;
import org.opendaylight.netconf.shaded.exificient.core.CodingMode;
import org.opendaylight.netconf.shaded.exificient.core.FidelityOptions;
import org.opendaylight.netconf.shaded.exificient.core.exceptions.UnsupportedOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfClientSessionNegotiatorFactory {
    public static final Set<String> EXI_CLIENT_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0", (Object)"urn:ietf:params:netconf:base:1.1", (Object)"urn:ietf:params:netconf:capability:exi:1.0");
    public static final Set<String> LEGACY_EXI_CLIENT_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0", (Object)"urn:ietf:params:netconf:capability:exi:1.0");
    public static final Set<String> DEFAULT_CLIENT_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0", (Object)"urn:ietf:params:netconf:base:1.1");
    public static final Set<String> LEGACY_FRAMING_CLIENT_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0");
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClientSessionNegotiatorFactory.class);
    private static final String START_EXI_MESSAGE_ID = "default-start-exi";
    private static final EXIParameters DEFAULT_OPTIONS;
    private final Optional<NetconfHelloMessageAdditionalHeader> additionalHeader;
    private final @NonNegative int maximumIncomingChunkSize;
    private final Set<String> clientCapabilities;
    private final long connectionTimeoutMillis;
    private final NetconfTimer timer;
    private final EXIParameters options;

    public NetconfClientSessionNegotiatorFactory(NetconfTimer timer, Optional<NetconfHelloMessageAdditionalHeader> additionalHeader, long connectionTimeoutMillis) {
        this(timer, additionalHeader, connectionTimeoutMillis, DEFAULT_OPTIONS);
    }

    public NetconfClientSessionNegotiatorFactory(NetconfTimer timer, Optional<NetconfHelloMessageAdditionalHeader> additionalHeader, long connectionTimeoutMillis, @NonNegative int maximumIncomingChunkSize) {
        this(timer, additionalHeader, connectionTimeoutMillis, DEFAULT_OPTIONS, EXI_CLIENT_CAPABILITIES, maximumIncomingChunkSize);
    }

    public NetconfClientSessionNegotiatorFactory(NetconfTimer timer, Optional<NetconfHelloMessageAdditionalHeader> additionalHeader, long connectionTimeoutMillis, Set<String> capabilities) {
        this(timer, additionalHeader, connectionTimeoutMillis, DEFAULT_OPTIONS, capabilities);
    }

    public NetconfClientSessionNegotiatorFactory(NetconfTimer timer, Optional<NetconfHelloMessageAdditionalHeader> additionalHeader, long connectionTimeoutMillis, EXIParameters exiOptions) {
        this(timer, additionalHeader, connectionTimeoutMillis, exiOptions, EXI_CLIENT_CAPABILITIES);
    }

    public NetconfClientSessionNegotiatorFactory(NetconfTimer timer, Optional<NetconfHelloMessageAdditionalHeader> additionalHeader, long connectionTimeoutMillis, EXIParameters exiOptions, Set<String> capabilities) {
        this(timer, additionalHeader, connectionTimeoutMillis, exiOptions, capabilities, NetconfSessionNegotiator.DEFAULT_MAXIMUM_INCOMING_CHUNK_SIZE);
    }

    public NetconfClientSessionNegotiatorFactory(NetconfTimer timer, Optional<NetconfHelloMessageAdditionalHeader> additionalHeader, long connectionTimeoutMillis, EXIParameters exiOptions, Set<String> capabilities, @NonNegative int maximumIncomingChunkSize) {
        this.timer = Objects.requireNonNull(timer);
        this.additionalHeader = additionalHeader;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.options = exiOptions;
        this.clientCapabilities = capabilities;
        this.maximumIncomingChunkSize = maximumIncomingChunkSize;
    }

    public long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public NetconfClientSessionNegotiator getSessionNegotiator(NetconfClientSessionListener sessionListener, Channel channel, Promise<NetconfClientSession> promise) {
        return new NetconfClientSessionNegotiator(HelloMessage.createClientHello(this.clientCapabilities, this.additionalHeader), NetconfStartExiMessageProvider.create((EXIParameters)this.options, (String)START_EXI_MESSAGE_ID), promise, channel, this.timer, sessionListener, this.connectionTimeoutMillis, this.maximumIncomingChunkSize);
    }

    static {
        FidelityOptions fidelity = FidelityOptions.createDefault();
        try {
            fidelity.setFidelity("PRESERVE_DTDS", true);
            fidelity.setFidelity("PRESERVE_LEXICAL_VALUES", true);
            fidelity.setFidelity("PRESERVE_PREFIXES", true);
        }
        catch (UnsupportedOption e) {
            LOG.warn("Failed to set fidelity options, continuing", (Throwable)e);
        }
        DEFAULT_OPTIONS = new EXIParameters(CodingMode.BYTE_PACKED, fidelity);
    }
}

