/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Promise;
import java.util.Set;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.checkerframework.checker.index.qual.NonNegative;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.api.messages.HelloMessage;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.messages.RpcMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfMessageUtil;
import org.opendaylight.netconf.client.XMLNetconfUtil;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.nettyutil.AbstractNetconfSession;
import org.opendaylight.netconf.nettyutil.NetconfSessionNegotiator;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NetconfClientSessionNegotiator
extends NetconfSessionNegotiator<NetconfClientSession, NetconfClientSessionListener> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClientSessionNegotiator.class);
    private static final XPathExpression SESSION_ID_X_PATH = XMLNetconfUtil.compileXPath("/netconf:hello/netconf:session-id");
    private static final XPathExpression SESSION_ID_X_PATH_NO_NAMESPACE = XMLNetconfUtil.compileXPath("/hello/session-id");
    private static final String EXI_1_0_CAPABILITY_MARKER = "exi:1.0";
    private static final Interner<Set<String>> INTERNER = Interners.newWeakInterner();
    private final RpcMessage startExi;

    NetconfClientSessionNegotiator(HelloMessage hello, RpcMessage startExi, Promise<NetconfClientSession> promise, Channel channel, NetconfTimer timer, NetconfClientSessionListener sessionListener, long connectionTimeoutMillis, @NonNegative int maximumIncomingChunkSize) {
        super(hello, promise, channel, timer, (NetconfSessionListener)sessionListener, connectionTimeoutMillis, maximumIncomingChunkSize);
        this.startExi = startExi;
    }

    protected void handleMessage(HelloMessage netconfMessage) throws NetconfDocumentedException {
        if (!this.ifNegotiatedAlready()) {
            LOG.debug("Server hello message received, starting negotiation on channel {}", (Object)this.channel);
            try {
                this.startNegotiation();
            }
            catch (Exception e) {
                LOG.warn("Unexpected negotiation failure on channel {}", (Object)this.channel, (Object)e);
                this.negotiationFailed(e);
                return;
            }
        }
        NetconfClientSession session = (NetconfClientSession)this.getSessionForHelloMessage(netconfMessage);
        this.replaceHelloMessageInboundHandler((AbstractNetconfSession)session);
        if (this.startExi != null && this.shouldUseExi(netconfMessage)) {
            LOG.debug("Netconf session {} should use exi.", (Object)session);
            this.tryToInitiateExi(session, this.startExi);
        } else {
            LOG.debug("Netconf session {} isn't capable of using exi.", (Object)session);
            this.negotiationSuccessful((AbstractNetconfSession)session);
        }
    }

    void tryToInitiateExi(NetconfClientSession session, RpcMessage startExiMessage) {
        this.channel.pipeline().addAfter("netconfMessageDecoder", "exiConfirmedHandler", (ChannelHandler)new ExiConfirmationInboundHandler(session, startExiMessage));
        session.sendMessage((NetconfMessage)startExiMessage).addListener(channelFuture -> {
            Throwable cause = channelFuture.cause();
            if (cause != null) {
                LOG.warn("Failed to send start-exi message {} on session {}", new Object[]{startExiMessage, session, cause});
                this.channel.pipeline().remove("exiConfirmedHandler");
            } else {
                LOG.trace("Start-exi message {} sent to socket on session {}", (Object)startExiMessage, (Object)session);
            }
        });
    }

    private boolean shouldUseExi(HelloMessage helloMsg) {
        return NetconfClientSessionNegotiator.containsExi10Capability(helloMsg.getDocument()) && NetconfClientSessionNegotiator.containsExi10Capability(this.localHello().getDocument());
    }

    private static boolean containsExi10Capability(Document doc) {
        NodeList nodeList = doc.getElementsByTagName("capability");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getTextContent().contains(EXI_1_0_CAPABILITY_MARKER)) continue;
            return true;
        }
        return false;
    }

    private static @NonNull SessionIdType extractSessionId(Document doc) {
        String textContent = NetconfClientSessionNegotiator.getSessionIdWithXPath(doc, SESSION_ID_X_PATH);
        if (Strings.isNullOrEmpty((String)textContent) && Strings.isNullOrEmpty((String)(textContent = NetconfClientSessionNegotiator.getSessionIdWithXPath(doc, SESSION_ID_X_PATH_NO_NAMESPACE)))) {
            throw new IllegalStateException("Session id not received from server, hello message: " + XmlUtil.toString((Document)doc));
        }
        return new SessionIdType(Uint32.valueOf((String)textContent));
    }

    private static String getSessionIdWithXPath(Document doc, XPathExpression sessionIdXPath) {
        Node sessionIdNode = NetconfClientSessionNegotiator.evaluateXPath(sessionIdXPath, doc);
        return sessionIdNode != null ? sessionIdNode.getTextContent() : null;
    }

    protected NetconfClientSession getSession(NetconfClientSessionListener sessionListener, Channel channel, HelloMessage message) {
        SessionIdType sessionId = NetconfClientSessionNegotiator.extractSessionId(message.getDocument());
        Set capabilities = (Set)INTERNER.intern((Object)ImmutableSet.copyOf(NetconfMessageUtil.extractCapabilitiesFromHello(message.getDocument())));
        return new NetconfClientSession(sessionListener, channel, sessionId, capabilities);
    }

    @VisibleForTesting
    static Node evaluateXPath(XPathExpression expr, Object rootNode) {
        try {
            return (Node)expr.evaluate(rootNode, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Error while evaluating xpath expression " + String.valueOf(expr), e);
        }
    }

    private final class ExiConfirmationInboundHandler
    extends ChannelInboundHandlerAdapter {
        private static final String EXI_CONFIRMED_HANDLER = "exiConfirmedHandler";
        private final NetconfClientSession session;
        private final RpcMessage startExiMessage;

        ExiConfirmationInboundHandler(NetconfClientSession session, RpcMessage startExiMessage) {
            this.session = session;
            this.startExiMessage = startExiMessage;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ctx.pipeline().remove(EXI_CONFIRMED_HANDLER);
            NetconfMessage netconfMessage = (NetconfMessage)msg;
            if (NetconfMessageUtil.isOKMessage(netconfMessage)) {
                LOG.trace("Positive response on start-exi call received on session {}", (Object)this.session);
                try {
                    this.session.startExiCommunication((NetconfMessage)this.startExiMessage);
                }
                catch (RuntimeException e) {
                    LOG.warn("Unable to start exi communication, Communication will continue without exi on session {}", (Object)this.session, (Object)e);
                }
            } else if (NetconfMessageUtil.isErrorMessage(netconfMessage)) {
                LOG.warn("Error response to start-exi message {}, Communication will continue without exi on session {}", (Object)netconfMessage, (Object)this.session);
            } else {
                LOG.warn("Unexpected response to start-exi message, should be ok, was {}. Communication will continue without EXI and response message will be thrown away on session {}", (Object)netconfMessage, (Object)this.session);
            }
            NetconfClientSessionNegotiator.this.negotiationSuccessful((AbstractNetconfSession)this.session);
        }
    }
}

