/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.Channel;
import java.util.Collection;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.codec.MessageDecoder;
import org.opendaylight.netconf.codec.MessageWriter;
import org.opendaylight.netconf.codec.XMLMessageDecoder;
import org.opendaylight.netconf.codec.XMLMessageWriter;
import org.opendaylight.netconf.nettyutil.AbstractNetconfExiSession;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfClientSession
extends AbstractNetconfExiSession<NetconfClientSession, NetconfClientSessionListener> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfClientSession.class);
    private final Collection<String> capabilities;

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="'this' passed to logger")
    public NetconfClientSession(NetconfClientSessionListener sessionListener, Channel channel, SessionIdType sessionId, Collection<String> capabilities) {
        super((NetconfSessionListener)sessionListener, channel, sessionId);
        this.capabilities = capabilities;
        LOG.debug("Client Session {} created", (Object)this);
    }

    public Collection<String> getServerCapabilities() {
        return this.capabilities;
    }

    protected NetconfClientSession thisInstance() {
        return this;
    }

    protected void addExiHandlers(MessageDecoder decoder, MessageWriter encoder) {
        this.replaceMessageDecoder(decoder);
        this.setMessageWriter(encoder);
    }

    public void stopExiCommunication() {
        this.replaceMessageDecoder((MessageDecoder)new XMLMessageDecoder());
        this.setMessageWriter((MessageWriter)XMLMessageWriter.pretty());
    }
}

