/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.bootstrap.Bootstrap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.client.ClientChannelInitializer;
import org.opendaylight.netconf.client.ClientTransportChannelListener;
import org.opendaylight.netconf.client.NetconfClientFactory;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.ssh.SSHTransportStackFactory;
import org.opendaylight.netconf.transport.tcp.TCPClient;
import org.opendaylight.netconf.transport.tls.FixedSslHandlerFactory;
import org.opendaylight.netconf.transport.tls.SslHandlerFactory;
import org.opendaylight.netconf.transport.tls.TLSClient;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Singleton
@Component(service={NetconfClientFactory.class})
public final class NetconfClientFactoryImpl
implements NetconfClientFactory {
    private final SSHTransportStackFactory factory;
    private final NetconfTimer timer;

    public NetconfClientFactoryImpl(NetconfTimer timer, SSHTransportStackFactory factory) {
        this.timer = Objects.requireNonNull(timer);
        this.factory = Objects.requireNonNull(factory);
    }

    @Inject
    @Activate
    public NetconfClientFactoryImpl(@Reference NetconfTimer timer) {
        this(timer, new SSHTransportStackFactory("odl-netconf-client", 0));
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.factory.close();
    }

    @Override
    public ListenableFuture<NetconfClientSession> createClient(NetconfClientConfiguration configuration) throws UnsupportedConfigurationException {
        NetconfClientSessionListener sessionListener = configuration.getSessionListener();
        ClientTransportChannelListener transportListener = new ClientTransportChannelListener(new ClientChannelInitializer(this.createNegotiatorFactory(configuration), sessionListener));
        ListenableFuture stackFuture = switch (configuration.getProtocol()) {
            default -> throw new MatchException(null, null);
            case NetconfClientConfiguration.NetconfClientProtocol.SSH -> this.factory.connectClient("netconf", (TransportChannelListener)transportListener, configuration.getTcpParameters(), configuration.getSshParameters(), configuration.getSshConfigurator());
            case NetconfClientConfiguration.NetconfClientProtocol.TCP -> TCPClient.connect((TransportChannelListener)transportListener, (Bootstrap)this.factory.newBootstrap(), (TcpClientGrouping)configuration.getTcpParameters());
            case NetconfClientConfiguration.NetconfClientProtocol.TLS -> {
                SslHandlerFactory handlerFactory = configuration.getSslHandlerFactory();
                if (handlerFactory == null) {
                    handlerFactory = new FixedSslHandlerFactory(configuration.getTlsParameters());
                }
                yield TLSClient.connect((TransportChannelListener)transportListener, (Bootstrap)this.factory.newBootstrap(), (TcpClientGrouping)configuration.getTcpParameters(), (SslHandlerFactory)handlerFactory);
            }
        };
        Futures.addCallback((ListenableFuture)stackFuture, (FutureCallback)transportListener, (Executor)MoreExecutors.directExecutor());
        return transportListener.sessionFuture();
    }

    private @NonNull NetconfClientSessionNegotiatorFactory createNegotiatorFactory(NetconfClientConfiguration configuration) {
        List<Uri> capabilities = configuration.getOdlHelloCapabilities();
        if (capabilities == null || capabilities.isEmpty()) {
            return new NetconfClientSessionNegotiatorFactory(this.timer, configuration.getAdditionalHeader(), (long)configuration.getConnectionTimeoutMillis(), configuration.getMaximumIncomingChunkSize());
        }
        ImmutableSet stringCapabilities = (ImmutableSet)capabilities.stream().map(Uri::getValue).collect(ImmutableSet.toImmutableSet());
        return new NetconfClientSessionNegotiatorFactory(this.timer, configuration.getAdditionalHeader(), (long)configuration.getConnectionTimeoutMillis(), (Set<String>)stringCapabilities);
    }
}

