/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.client.ClientChannelInitializer;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.TransportStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientTransportChannelListener
implements TransportChannelListener<TransportChannel>,
FutureListener<NetconfClientSession>,
FutureCallback<TransportStack> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientTransportChannelListener.class);
    private final @NonNull SettableFuture<NetconfClientSession> sessionFuture = SettableFuture.create();
    private final ClientChannelInitializer initializer;

    ClientTransportChannelListener(ClientChannelInitializer initializer) {
        this.initializer = Objects.requireNonNull(initializer);
    }

    @NonNull ListenableFuture<NetconfClientSession> sessionFuture() {
        return this.sessionFuture;
    }

    public void onTransportChannelEstablished(TransportChannel channel) {
        LOG.debug("Initializing established transport {}", (Object)channel);
        Channel nettyChannel = channel.channel();
        Promise promise = nettyChannel.eventLoop().newPromise();
        this.initializer.initialize(nettyChannel, promise);
        promise.addListener((GenericFutureListener)this);
    }

    public void onTransportChannelFailed(Throwable cause) {
        this.sessionFuture.setException(cause);
    }

    public void operationComplete(Future<NetconfClientSession> future) throws Exception {
        Throwable cause = future.cause();
        if (cause != null) {
            this.sessionFuture.setException(cause);
        } else {
            this.sessionFuture.set((Object)((NetconfClientSession)((Object)future.getNow())));
        }
    }

    public void onSuccess(TransportStack result) {
    }

    public void onFailure(Throwable cause) {
        this.onTransportChannelFailed(cause);
    }
}

