/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.Promise;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.opendaylight.netconf.nettyutil.AbstractChannelInitializer;

public final class ClientChannelInitializer
extends AbstractChannelInitializer<NetconfClientSession> {
    private final NetconfClientSessionNegotiatorFactory negotiatorFactory;
    private final NetconfClientSessionListener sessionListener;

    public ClientChannelInitializer(@NonNull NetconfClientSessionNegotiatorFactory negotiatorFactory, @NonNull NetconfClientSessionListener sessionListener) {
        this.negotiatorFactory = Objects.requireNonNull(negotiatorFactory);
        this.sessionListener = Objects.requireNonNull(sessionListener);
    }

    protected void initializeSessionNegotiator(Channel ch, Promise<NetconfClientSession> promise) {
        ch.pipeline().addAfter("netconfMessageDecoder", "negotiator", (ChannelHandler)this.negotiatorFactory.getSessionNegotiator(this.sessionListener, ch, promise));
        ch.config().setConnectTimeoutMillis((int)this.negotiatorFactory.getConnectionTimeoutMillis());
    }
}

