/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.messages;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class RpcMessage
extends NetconfMessage {
    public static final @NonNull String ELEMENT_NAME = "rpc";

    private RpcMessage(Document document) {
        super(document);
    }

    static @NonNull RpcMessage ofChecked(Document document) throws DocumentedException {
        Element root = document.getDocumentElement();
        Attr messageIdAttr = root.getAttributeNode("message-id");
        if (messageIdAttr == null) {
            throw new DocumentedException("Missing message-id attribute", ErrorType.RPC, ErrorTag.MISSING_ATTRIBUTE, ErrorSeverity.ERROR, (Map<String, String>)ImmutableMap.of((Object)"bad-attribute", (Object)"message-id", (Object)"bad-element", (Object)ELEMENT_NAME));
        }
        return new RpcMessage(document);
    }

    public static @NonNull RpcMessage of(Document document) throws DocumentedException {
        Element root = document.getDocumentElement();
        String rootName = root.getLocalName();
        if (!ELEMENT_NAME.equals(rootName)) {
            throw new DocumentedException("Unexpected element name " + rootName, ErrorType.PROTOCOL, ErrorTag.UNKNOWN_ELEMENT, ErrorSeverity.ERROR, (Map<String, String>)ImmutableMap.of((Object)"bad-element", (Object)rootName));
        }
        String rootNs = root.getNamespaceURI();
        if (!"urn:ietf:params:xml:ns:netconf:base:1.0".equals(rootNs)) {
            throw new DocumentedException("Unexpected element namespace " + rootNs, ErrorType.PROTOCOL, ErrorTag.UNKNOWN_NAMESPACE, ErrorSeverity.ERROR, (Map<String, String>)ImmutableMap.of((Object)"bad-element", (Object)rootName, (Object)"bad-namespace", (Object)rootNs));
        }
        return RpcMessage.ofChecked(document);
    }

    public static @NonNull RpcMessage ofOperation(String messageId, Document document) {
        Element rpcElem = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", ELEMENT_NAME);
        rpcElem.appendChild(document.getDocumentElement());
        rpcElem.setAttribute("message-id", Objects.requireNonNull(messageId));
        document.appendChild(rpcElem);
        return new RpcMessage(document);
    }

    public @NonNull String messageId() {
        return this.getDocument().getDocumentElement().getAttribute("message-id");
    }
}

