/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.messages;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class HelloMessage
extends NetconfMessage {
    public static final @NonNull String ELEMENT_NAME = "hello";
    private final NetconfHelloMessageAdditionalHeader additionalHeader;

    private HelloMessage(NetconfHelloMessageAdditionalHeader additionalHeader, Document doc) {
        super(doc);
        this.additionalHeader = additionalHeader;
    }

    public HelloMessage(Document doc) {
        this(doc, null);
    }

    public HelloMessage(Document doc, NetconfHelloMessageAdditionalHeader additionalHeader) {
        this(additionalHeader, doc);
        HelloMessage.checkHelloMessage(doc);
    }

    public Optional<NetconfHelloMessageAdditionalHeader> getAdditionalHeader() {
        return Optional.ofNullable(this.additionalHeader);
    }

    private static void checkHelloMessage(Document doc) {
        if (!HelloMessage.isHelloMessage(doc)) {
            throw new IllegalArgumentException(String.format("Hello message invalid format, should contain %s tag from namespace %s, but is: %s", ELEMENT_NAME, "urn:ietf:params:xml:ns:netconf:base:1.0", XmlUtil.toString(doc)));
        }
    }

    public static HelloMessage createClientHello(Iterable<String> capabilities, Optional<NetconfHelloMessageAdditionalHeader> additionalHeaderOptional) {
        return new HelloMessage(HelloMessage.createHelloMessageDoc(capabilities), additionalHeaderOptional.orElse(null));
    }

    private static Document createHelloMessageDoc(Iterable<String> capabilities) {
        Document doc = UntrustedXML.newDocumentBuilder().newDocument();
        Element helloElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", ELEMENT_NAME);
        Element capabilitiesElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "capabilities");
        for (String capability : Sets.newHashSet(capabilities)) {
            Element capElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "capability");
            capElement.setTextContent(capability);
            capabilitiesElement.appendChild(capElement);
        }
        helloElement.appendChild(capabilitiesElement);
        doc.appendChild(helloElement);
        return doc;
    }

    public static HelloMessage createServerHello(Set<String> capabilities, SessionIdType sessionId) {
        Document doc = HelloMessage.createHelloMessageDoc(capabilities);
        Element sessionIdElement = doc.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "session-id");
        sessionIdElement.setTextContent(sessionId.getValue().toCanonicalString());
        doc.getDocumentElement().appendChild(sessionIdElement);
        return new HelloMessage(doc);
    }

    public static boolean isHelloMessage(NetconfMessage msg) {
        return HelloMessage.isHelloMessage(msg.getDocument());
    }

    public static boolean isHelloMessage(Document document) {
        XmlElement element = XmlElement.fromDomElement(document.getDocumentElement());
        if (!ELEMENT_NAME.equals(element.getName())) {
            return false;
        }
        String namespace = element.namespace();
        return namespace == null || "urn:ietf:params:xml:ns:netconf:base:1.0".equals(namespace);
    }
}

