/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.capability;

import java.net.URI;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.capability.Capability;

public enum SimpleCapability implements Capability
{
    BASE(":base:1.0", "urn:ietf:params:netconf:base:1.0"),
    BASE_1_1(":base:1.1", "urn:ietf:params:netconf:base:1.1"),
    CANDIDATE(":candidate", "urn:ietf:params:netconf:capability:candidate:1.0"),
    CONFIRMED_COMMIT(":confirmed-commit", "urn:ietf:params:netconf:capability:confirmed-commit:1.0"),
    CONFIRMED_COMMIT_1_1(":confirmed-commit:1.1", "urn:ietf:params:netconf:capability:confirmed-commit:1.1"),
    INTERLEAVE(":interleave", "urn:ietf:params:netconf:capability:interleave:1.0"),
    NOTIFICATION(":notification", "urn:ietf:params:netconf:capability:notification:1.0"),
    PARTIAL_LOCK(":partial-lock", "urn:ietf:params:netconf:capability:partial-lock:1.0"),
    ROLLBACK_ON_ERROR(":rollback-on-error", "urn:ietf:params:netconf:capability:rollback-on-error:1.0"),
    STARTUP(":startup", "urn:ietf:params:netconf:capability:startup:1.0"),
    TIME(":time:1.0", "urn:ietf:params:netconf:capability:time:1.0"),
    URL(":url", "urn:ietf:params:netconf:capability:url:1.0"),
    VALIDATE(":validate", "urn:ietf:params:netconf:capability:validate:1.0"),
    VALIDATE_1_1(":validate:1.1", "urn:ietf:params:netconf:capability:validate:1.1"),
    XPATH(":xpath", "urn:ietf:params:netconf:capability:xpath:1.0"),
    YANG_LIBRARY(":yang-library", "urn:ietf:params:netconf:capability:yang-library:1.0"),
    YANG_LIBRARY_1_1(":yang-library:1.1", "urn:ietf:params:netconf:capability:yang-library:1.1"),
    WITH_DEFAULTS(":with-defaults", "urn:ietf:params:netconf:capability:with-defaults:1.0"),
    WITH_OPERATIONAL_DEFAULTS(":with-operational-defaults", "urn:ietf:params:netconf:capability:with-operational-defaults:1.0"),
    WRITABLE_RUNNING(":writable-running", "urn:ietf:params:netconf:capability:writable-running:1.0");

    private final @NonNull String capabilityName;
    private final @NonNull String urn;
    private final @NonNull URI uri;

    private SimpleCapability(String capabilityName, String urn) {
        this.capabilityName = Objects.requireNonNull(capabilityName);
        this.urn = Objects.requireNonNull(urn);
        this.uri = URI.create(urn);
    }

    public @NonNull String capabilityName() {
        return this.capabilityName;
    }

    @Override
    public String urn() {
        return this.urn;
    }

    @Override
    public URI toURI() {
        return this.uri;
    }

    public static @NonNull SimpleCapability ofURN(String urn) {
        SimpleCapability capability = SimpleCapability.forURN(urn);
        if (capability == null) {
            throw new IllegalArgumentException(urn + " does not match a known protocol capability");
        }
        return capability;
    }

    public static SimpleCapability forURN(String urn) {
        return switch (urn) {
            case "urn:ietf:params:netconf:base:1.0" -> BASE;
            case "urn:ietf:params:netconf:base:1.1" -> BASE_1_1;
            case "urn:ietf:params:netconf:capability:candidate:1.0" -> CANDIDATE;
            case "urn:ietf:params:netconf:capability:confirmed-commit:1.0" -> CONFIRMED_COMMIT;
            case "urn:ietf:params:netconf:capability:confirmed-commit:1.1" -> CONFIRMED_COMMIT_1_1;
            case "urn:ietf:params:netconf:capability:interleave:1.0" -> INTERLEAVE;
            case "urn:ietf:params:netconf:capability:notification:1.0" -> NOTIFICATION;
            case "urn:ietf:params:netconf:capability:partial-lock:1.0" -> PARTIAL_LOCK;
            case "urn:ietf:params:netconf:capability:rollback-on-error:1.0" -> ROLLBACK_ON_ERROR;
            case "urn:ietf:params:netconf:capability:startup:1.0" -> STARTUP;
            case "urn:ietf:params:netconf:capability:time:1.0" -> TIME;
            case "urn:ietf:params:netconf:capability:url:1.0" -> URL;
            case "urn:ietf:params:netconf:capability:validate:1.0" -> VALIDATE;
            case "urn:ietf:params:netconf:capability:validate:1.1" -> VALIDATE_1_1;
            case "urn:ietf:params:netconf:capability:with-defaults:1.0" -> WITH_DEFAULTS;
            case "urn:ietf:params:netconf:capability:with-operational-defaults:1.0" -> WITH_OPERATIONAL_DEFAULTS;
            case "urn:ietf:params:netconf:capability:writable-running:1.0" -> WRITABLE_RUNNING;
            case "urn:ietf:params:netconf:capability:xpath:1.0" -> XPATH;
            case "urn:ietf:params:netconf:capability:yang-library:1.0" -> YANG_LIBRARY;
            case "urn:ietf:params:netconf:capability:yang-library:1.1" -> YANG_LIBRARY_1_1;
            default -> null;
        };
    }
}

