/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public enum EffectiveOperation {
    MERGE("merge", true, true),
    REPLACE("replace", true, true),
    CREATE("create", true, false),
    DELETE("delete", true, false),
    REMOVE("remove", true, false),
    NONE("none", false, true);

    private final @NonNull String xmlValue;
    private final boolean isDefaultOperation;
    private final boolean isOperation;

    private EffectiveOperation(String xmlValue, boolean isOperation, boolean isDefaultOperation) {
        this.xmlValue = Objects.requireNonNull(xmlValue);
        this.isDefaultOperation = isDefaultOperation;
        this.isOperation = isOperation;
    }

    public static @NonNull EffectiveOperation ofXmlValue(String xmlValue) {
        return switch (xmlValue) {
            case "merge" -> MERGE;
            case "replace" -> REPLACE;
            case "remove" -> REMOVE;
            case "delete" -> DELETE;
            case "create" -> CREATE;
            case "none" -> NONE;
            default -> throw new IllegalArgumentException("Unknown operation " + xmlValue);
        };
    }

    public @NonNull String xmlValue() {
        return this.xmlValue;
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public boolean isAsDefaultPermitted() {
        return this.isDefaultOperation;
    }

    public boolean isDefaultOperation() {
        return this.isDefaultOperation;
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public boolean isOnElementPermitted() {
        return this.isOperation;
    }

    public boolean isOperation() {
        return this.isOperation;
    }
}

