/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.keystore.legacy.impl.AbstractRpc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemovePrivateKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemovePrivateKeyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemovePrivateKeyOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemovePrivateKeyOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKeyKey;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultRemovePrivateKey
extends AbstractRpc
implements RemovePrivateKey {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRemovePrivateKey.class);

    DefaultRemovePrivateKey(DataBroker dataBroker) {
        super(dataBroker);
    }

    @Override
    public ListenableFuture<RpcResult<RemovePrivateKeyOutput>> invoke(RemovePrivateKeyInput input) {
        Set<String> names = input.getName();
        if (names == null || names.isEmpty()) {
            return RpcResultBuilder.success((Object)new RemovePrivateKeyOutputBuilder().build()).buildFuture();
        }
        Set keys = names.stream().map(PrivateKeyKey::new).collect(Collectors.toSet());
        LOG.debug("Removing private keys: {}", keys);
        WriteTransaction tx = this.newTransaction();
        for (PrivateKeyKey key : keys) {
            tx.delete(LogicalDatastoreType.CONFIGURATION, (DataObjectIdentifier)DataObjectIdentifier.builder(Keystore.class).child(PrivateKey.class, (Key)key).build());
        }
        return tx.commit().transform(commitInfo -> {
            LOG.debug("Removed trusted keys: {}", (Object)keys);
            return RpcResultBuilder.success((Object)new RemovePrivateKeyOutputBuilder().build()).build();
        }, MoreExecutors.directExecutor());
    }
}

