/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.keystore.legacy.impl.AbstractRpc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemoveKeystoreEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemoveKeystoreEntryInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemoveKeystoreEntryOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemoveKeystoreEntryOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.keystore.entry.KeyCredential;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.keystore.entry.KeyCredentialKey;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultRemoveKeystoreEntry
extends AbstractRpc
implements RemoveKeystoreEntry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRemoveKeystoreEntry.class);

    DefaultRemoveKeystoreEntry(DataBroker dataBroker) {
        super(dataBroker);
    }

    @Override
    public ListenableFuture<RpcResult<RemoveKeystoreEntryOutput>> invoke(RemoveKeystoreEntryInput input) {
        Set<String> keyIds = input.getKeyId();
        if (keyIds == null || keyIds.isEmpty()) {
            return RpcResultBuilder.success((Object)new RemoveKeystoreEntryOutputBuilder().build()).buildFuture();
        }
        Set keys = keyIds.stream().map(KeyCredentialKey::new).collect(Collectors.toSet());
        LOG.debug("Removing keypairs: {}", keys);
        WriteTransaction tx = this.newTransaction();
        for (KeyCredentialKey key : keys) {
            tx.delete(LogicalDatastoreType.CONFIGURATION, (DataObjectIdentifier)DataObjectIdentifier.builder(Keystore.class).child(KeyCredential.class, (Key)key).build());
        }
        return tx.commit().transform(commitInfo -> {
            LOG.debug("Removed keypairs: {}", (Object)keys);
            return RpcResultBuilder.success((Object)new RemoveKeystoreEntryOutputBuilder().build()).build();
        }, MoreExecutors.directExecutor());
    }
}

