/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.netconf.keystore.legacy.impl.DefaultNetconfKeystoreService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.keystore.entry.KeyCredential;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.trusted.certificates.TrustedCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
record ConfigListener(DefaultNetconfKeystoreService keystore) implements DataTreeChangeListener<Keystore>
{
    private static final Logger LOG = LoggerFactory.getLogger(ConfigListener.class);

    ConfigListener {
        Objects.requireNonNull(keystore);
    }

    public void onInitialData() {
        this.keystore.runUpdate(builder -> {
            builder.privateKeys().clear();
            builder.trustedCertificates().clear();
        });
    }

    public void onDataTreeChanged(List<DataTreeModification<Keystore>> changes) {
        LOG.debug("Starting update with {} changes", (Object)changes.size());
        Stopwatch sw = Stopwatch.createStarted();
        this.keystore.runUpdate(builder -> ConfigListener.onDataTreeChanged(builder, changes));
        LOG.debug("Update finished in {}", (Object)sw);
    }

    private static void onDataTreeChanged(DefaultNetconfKeystoreService.ConfigStateBuilder builder, List<DataTreeModification<Keystore>> changes) {
        for (DataTreeModification<Keystore> change : changes) {
            LOG.debug("Processing change {}", change);
            DataObjectModification rootNode = change.getRootNode();
            for (DataObjectModification mod : rootNode.getModifiedChildren(PrivateKey.class)) {
                switch (mod.modificationType()) {
                    case SUBTREE_MODIFIED: 
                    case WRITE: {
                        PrivateKey privateKey = (PrivateKey)mod.dataAfter();
                        builder.privateKeys().put(privateKey.requireName(), privateKey);
                        break;
                    }
                    case DELETE: {
                        builder.privateKeys().remove(((PrivateKey)mod.dataBefore()).requireName());
                        break;
                    }
                }
            }
            for (DataObjectModification mod : rootNode.getModifiedChildren(TrustedCertificate.class)) {
                switch (mod.modificationType()) {
                    case SUBTREE_MODIFIED: 
                    case WRITE: {
                        TrustedCertificate trustedCertificate = (TrustedCertificate)mod.dataAfter();
                        builder.trustedCertificates().put(trustedCertificate.requireName(), trustedCertificate);
                        break;
                    }
                    case DELETE: {
                        builder.trustedCertificates().remove(((TrustedCertificate)mod.dataBefore()).requireName());
                        break;
                    }
                }
            }
            for (DataObjectModification mod : rootNode.getModifiedChildren(KeyCredential.class)) {
                switch (mod.modificationType()) {
                    case SUBTREE_MODIFIED: 
                    case WRITE: {
                        KeyCredential keyCredential = (KeyCredential)mod.dataAfter();
                        builder.credentials().put(keyCredential.requireKeyId(), keyCredential);
                        break;
                    }
                    case DELETE: {
                        builder.credentials().remove(((KeyCredential)mod.dataBefore()).requireKeyId());
                        break;
                    }
                }
            }
        }
    }
}

