/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.keystore.legacy.impl.AbstractEncryptingRpc;
import org.opendaylight.netconf.keystore.legacy.impl.SecurityHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddTrustedCertificate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddTrustedCertificateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddTrustedCertificateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddTrustedCertificateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.trusted.certificates.TrustedCertificate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.trusted.certificates.TrustedCertificateBuilder;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultAddTrustedCertificate
extends AbstractEncryptingRpc
implements AddTrustedCertificate {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAddTrustedCertificate.class);

    DefaultAddTrustedCertificate(DataBroker dataBroker, AAAEncryptionService encryptionService) {
        super(dataBroker, encryptionService);
    }

    @Override
    public ListenableFuture<RpcResult<AddTrustedCertificateOutput>> invoke(AddTrustedCertificateInput input) {
        Map certs = input.getTrustedCertificate();
        if (certs == null || certs.isEmpty()) {
            return RpcResultBuilder.success((Object)new AddTrustedCertificateOutputBuilder().build()).buildFuture();
        }
        LOG.debug("Updating trusted certificates: {}", (Object)certs);
        ArrayList<TrustedCertificate> certificates = new ArrayList<TrustedCertificate>(certs.size());
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc.trusted.certificates.TrustedCertificate certificate : certs.values()) {
            TrustedCertificate cert2;
            String certName = certificate.getName();
            try {
                X509Certificate validCert = SecurityHelper.decodeCertificate(certificate.getCertificate());
                cert2 = new TrustedCertificateBuilder().setName(certName).setCertificate(this.encryptEncoded(validCert.getEncoded())).build();
            }
            catch (GeneralSecurityException e) {
                LOG.debug("Cannot encrypt certificate {}}", (Object)certificate, (Object)e);
                return DefaultAddTrustedCertificate.returnFailed("Failed to encrypt certificate " + certName, e);
            }
            catch (IOException e) {
                LOG.debug("Cannot decode certificate {}}", (Object)certificate, (Object)e);
                return DefaultAddTrustedCertificate.returnFailed("Failed to decode certificate " + certName, e);
            }
            certificates.add(cert2);
        }
        WriteTransaction tx = this.newTransaction();
        certificates.forEach(cert -> tx.put(LogicalDatastoreType.CONFIGURATION, (DataObjectIdentifier)DataObjectIdentifier.builder(Keystore.class).child(TrustedCertificate.class, (Key)cert.key()).build(), (DataObject)cert));
        return tx.commit().transform(commitInfo -> {
            LOG.debug("Updated trusted certificates: {}", certs.keySet());
            return RpcResultBuilder.success((Object)new AddTrustedCertificateOutputBuilder().build()).build();
        }, MoreExecutors.directExecutor());
    }
}

