/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Map;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.keystore.legacy.impl.AbstractEncryptingRpc;
import org.opendaylight.netconf.keystore.legacy.impl.SecurityHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddKeystoreEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddKeystoreEntryInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddKeystoreEntryOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddKeystoreEntryOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.keystore.entry.KeyCredential;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.keystore.entry.KeyCredentialBuilder;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultAddKeystoreEntry
extends AbstractEncryptingRpc
implements AddKeystoreEntry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAddKeystoreEntry.class);

    DefaultAddKeystoreEntry(DataBroker dataBroker, AAAEncryptionService encryptionService) {
        super(dataBroker, encryptionService);
    }

    @Override
    public ListenableFuture<RpcResult<AddKeystoreEntryOutput>> invoke(AddKeystoreEntryInput input) {
        Map plain = input.getKeyCredential();
        if (plain == null || plain.isEmpty()) {
            return RpcResultBuilder.success((Object)new AddKeystoreEntryOutputBuilder().build()).buildFuture();
        }
        LOG.debug("Adding keypairs: {}", (Object)plain);
        ArrayList<KeyCredential> encrypted = new ArrayList<KeyCredential>(plain.size());
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc.keystore.entry.KeyCredential credential : plain.values()) {
            byte[] encodedPub;
            byte[] encodedPriv;
            KeyPair keyPair;
            String keyId = credential.getKeyId();
            try {
                keyPair = new SecurityHelper().decodePrivateKey(credential.getPrivateKey(), credential.getPassphrase());
            }
            catch (IOException e) {
                LOG.debug("Cannot decode private key {}}", (Object)keyId, (Object)e);
                return DefaultAddKeystoreEntry.returnFailed("Failed to decode private key " + keyId, e);
            }
            PrivateKey priv = keyPair.getPrivate();
            try {
                encodedPriv = this.encryptEncoded(priv.getEncoded());
                encodedPub = this.encryptEncoded(keyPair.getPublic().getEncoded());
            }
            catch (GeneralSecurityException e) {
                LOG.debug("Cannot encrypt key credential {}}", (Object)credential, (Object)e);
                return DefaultAddKeystoreEntry.returnFailed("Failed to encrypt key credential " + keyId, e);
            }
            encrypted.add(new KeyCredentialBuilder().setKeyId(credential.getKeyId()).setAlgorithm(priv.getAlgorithm()).setPrivateKey(encodedPriv).setPublicKey(encodedPub).build());
        }
        WriteTransaction tx = this.newTransaction();
        encrypted.forEach(keypair -> tx.put(LogicalDatastoreType.CONFIGURATION, (DataObjectIdentifier)DataObjectIdentifier.builder(Keystore.class).child(KeyCredential.class, (Key)keypair.key()).build(), (DataObject)keypair));
        return tx.commit().transform(commitInfo -> {
            LOG.debug("Updated keypairs: {}", plain.keySet());
            return RpcResultBuilder.success((Object)new AddKeystoreEntryOutputBuilder().build()).build();
        }, MoreExecutors.directExecutor());
    }
}

