package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Fields associated with a packet whick are not in the header.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-packet-fields</b>
 * <pre>
 * grouping metadata {
 *   leaf input-interface {
 *     type if:interface-ref {
 *       require-instance false;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-packet-fields/metadata</i>
 *
 */
public interface Metadata
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("metadata");

    @Override
    Class<? extends Metadata> implementedInterface();
    
    /**
     * Packet was received on this interface.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>inputInterface</code>, or <code>null</code> if not present
     */
    String getInputInterface();

}

