package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.packet.fields.rev160218;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Fields in Ethernet header.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>ietf-packet-fields</b>
 * <pre>
 * grouping acl-eth-header-fields {
 *   leaf destination-mac-address {
 *     type yang:mac-address;
 *   }
 *   leaf destination-mac-address-mask {
 *     type yang:mac-address;
 *   }
 *   leaf source-mac-address {
 *     type yang:mac-address;
 *   }
 *   leaf source-mac-address-mask {
 *     type yang:mac-address;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>ietf-packet-fields/acl-eth-header-fields</i>
 *
 */
public interface AclEthHeaderFields
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("acl-eth-header-fields");

    @Override
    Class<? extends AclEthHeaderFields> implementedInterface();
    
    /**
     * Destination IEEE 802 MAC address.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress</code> <code>destinationMacAddress</code>, or <code>null</code> if not present
     */
    MacAddress getDestinationMacAddress();
    
    /**
     * Destination IEEE 802 MAC address mask.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress</code> <code>destinationMacAddressMask</code>, or <code>null</code> if not present
     */
    MacAddress getDestinationMacAddressMask();
    
    /**
     * Source IEEE 802 MAC address.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress</code> <code>sourceMacAddress</code>, or <code>null</code> if not present
     */
    MacAddress getSourceMacAddress();
    
    /**
     * Source IEEE 802 MAC address mask.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress</code> <code>sourceMacAddressMask</code>, or <code>null</code> if not present
     */
    MacAddress getSourceMacAddressMask();

}

