/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.annotations.Beta;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.DOMDataTreePrefixTableEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class DOMDataTreePrefixTable<V> {
    private static final Logger LOG = LoggerFactory.getLogger(DOMDataTreePrefixTable.class);
    private final Map<LogicalDatastoreType, DOMDataTreePrefixTableEntry<V>> roots = new EnumMap<LogicalDatastoreType, DOMDataTreePrefixTableEntry<V>>(LogicalDatastoreType.class);

    private DOMDataTreePrefixTable() {
    }

    public static <V> DOMDataTreePrefixTable<V> create() {
        return new DOMDataTreePrefixTable<V>();
    }

    public @Nullable DOMDataTreePrefixTableEntry<V> lookup(@NonNull DOMDataTreeIdentifier prefix) {
        DOMDataTreePrefixTableEntry<V> t = this.roots.get(prefix.getDatastoreType());
        return t == null ? null : t.lookup(prefix.getRootIdentifier());
    }

    public void store(@NonNull DOMDataTreeIdentifier prefix, @NonNull V value) {
        DOMDataTreePrefixTableEntry<V> domDataTreePrefixTableEntry = this.roots.get(prefix.getDatastoreType());
        if (domDataTreePrefixTableEntry == null) {
            domDataTreePrefixTableEntry = new DOMDataTreePrefixTableEntry();
            this.roots.put(prefix.getDatastoreType(), domDataTreePrefixTableEntry);
        }
        domDataTreePrefixTableEntry.store(prefix.getRootIdentifier(), value);
    }

    public void remove(@NonNull DOMDataTreeIdentifier prefix) {
        DOMDataTreePrefixTableEntry<V> t = this.roots.get(prefix.getDatastoreType());
        if (t == null) {
            LOG.warn("Shard registration {} points to non-existent table", (Object)prefix);
            return;
        }
        t.remove(prefix.getRootIdentifier());
    }
}

