/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.osgi.impl;

import java.util.List;
import java.util.Objects;
import org.apache.karaf.features.DeploymentEvent;
import org.apache.karaf.features.DeploymentListener;
import org.apache.karaf.features.FeaturesService;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.schema.osgi.impl.RegularYangModuleInfoRegistry;
import org.opendaylight.mdsal.dom.schema.osgi.impl.YangModuleInfoRegistry;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KarafYangModuleInfoRegistry
extends YangModuleInfoRegistry
implements DeploymentListener {
    private static final Logger LOG = LoggerFactory.getLogger(KarafYangModuleInfoRegistry.class);
    private final RegularYangModuleInfoRegistry delegate;
    private boolean scannerEnabled = false;
    private boolean updatesEnabled = false;

    private KarafYangModuleInfoRegistry(RegularYangModuleInfoRegistry delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    static @NonNull KarafYangModuleInfoRegistry create(FeaturesService features, RegularYangModuleInfoRegistry delegate) {
        KarafYangModuleInfoRegistry ret = new KarafYangModuleInfoRegistry(delegate);
        features.registerListener((DeploymentListener)ret);
        return ret;
    }

    public synchronized void deploymentEvent(DeploymentEvent event) {
        LOG.debug("Features service indicates {}", (Object)event);
        switch (event) {
            case DEPLOYMENT_STARTED: 
            case BUNDLES_INSTALLED: {
                this.updatesEnabled = false;
                LOG.debug("BindingRuntimeContext updates disabled");
                break;
            }
            default: {
                this.updatesEnabled = true;
                LOG.debug("BindingRuntimeContext updates enabled");
                if (!this.scannerEnabled) break;
                this.delegate.enableScannerAndUpdate();
            }
        }
    }

    @Override
    synchronized void scannerUpdate() {
        if (this.updatesEnabled) {
            this.delegate.scannerUpdate();
        }
    }

    @Override
    synchronized void enableScannerAndUpdate() {
        this.scannerEnabled = true;
        if (this.updatesEnabled) {
            this.delegate.enableScannerAndUpdate();
        }
    }

    @Override
    Registration registerInfos(List<YangModuleInfo> infos) {
        return this.delegate.registerInfos(infos);
    }

    @Override
    synchronized void close() {
        this.delegate.close();
    }

    @Override
    synchronized void scannerShutdown() {
        this.scannerEnabled = false;
        this.delegate.scannerShutdown();
    }
}

