/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.osgi;

import com.google.common.annotations.Beta;
import com.google.common.primitives.UnsignedLong;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;

@Beta
public interface ModelGenerationAware<S>
extends Immutable {
    public @NonNull UnsignedLong getGeneration();

    public @NonNull S getService();

    default public @NonNull Integer getServiceRanking() {
        return ModelGenerationAware.computeServiceRanking(this.getGeneration().longValue());
    }

    public static @NonNull Integer computeServiceRanking(long generation) {
        return generation >= 0L && generation <= Integer.MAX_VALUE ? (int)generation : Integer.MAX_VALUE;
    }
}

