/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

public final class DOMActionInstance
implements Immutable {
    private final Set<DOMDataTreeIdentifier> dataTrees;
    private final SchemaNodeIdentifier.Absolute type;

    private DOMActionInstance(SchemaNodeIdentifier.Absolute type, ImmutableSet<DOMDataTreeIdentifier> dataTrees) {
        this.type = Objects.requireNonNull(type);
        this.dataTrees = (Set)Objects.requireNonNull(dataTrees);
        Preconditions.checkArgument((!dataTrees.isEmpty() ? 1 : 0) != 0);
    }

    public static DOMActionInstance of(SchemaNodeIdentifier.Absolute type, Set<DOMDataTreeIdentifier> dataTrees) {
        return new DOMActionInstance(type, (ImmutableSet<DOMDataTreeIdentifier>)ImmutableSet.copyOf(dataTrees));
    }

    public static DOMActionInstance of(SchemaNodeIdentifier.Absolute type, DOMDataTreeIdentifier ... dataTrees) {
        return new DOMActionInstance(type, (ImmutableSet<DOMDataTreeIdentifier>)ImmutableSet.copyOf((Object[])dataTrees));
    }

    public static DOMActionInstance of(SchemaNodeIdentifier.Absolute type, LogicalDatastoreType datastore, YangInstanceIdentifier path) {
        return new DOMActionInstance(type, (ImmutableSet<DOMDataTreeIdentifier>)ImmutableSet.of((Object)DOMDataTreeIdentifier.of(datastore, path)));
    }

    public Set<DOMDataTreeIdentifier> getDataTrees() {
        return this.dataTrees;
    }

    public SchemaNodeIdentifier.Absolute getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.dataTrees);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DOMActionInstance)) return false;
        DOMActionInstance other = (DOMActionInstance)obj;
        if (!this.getType().equals((Object)other.type)) return false;
        if (!this.dataTrees.equals(other.dataTrees)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("dataTrees", this.dataTrees).toString();
    }
}

