/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.generator.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.model.api.TypeComment;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;

@NonNullByDefault
final class TypeComments {
    private static final Escaper ENTITY_ESCAPER = Escapers.builder().addEscape('<', "&lt;").addEscape('>', "&gt;").addEscape('&', "&amp;").addEscape('@', "&#64;").build();
    private static final Pattern TAIL_COMMENT_PATTERN = Pattern.compile("*/", 16);
    private static final CharMatcher NEWLINE_OR_TAB = CharMatcher.anyOf((CharSequence)"\n\t");
    private static final Pattern MULTIPLE_SPACES_PATTERN = Pattern.compile(" +");

    private TypeComments() {
    }

    public static Optional<TypeComment> description(DocumentedNode node) {
        String description = node.getDescription().orElse("");
        return description.isEmpty() ? Optional.empty() : Optional.of(() -> BindingGeneratorUtil.replaceAllIllegalChars(TypeComments.formatToParagraph(TAIL_COMMENT_PATTERN.matcher(ENTITY_ESCAPER.escape(description)).replaceAll("&#42;&#47;"), 0)));
    }

    private static String formatToParagraph(String text, int nextLineIndent) {
        if (Strings.isNullOrEmpty((String)text)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        String lineIndent = " ".repeat(nextLineIndent);
        String formattedText = MULTIPLE_SPACES_PATTERN.matcher(NEWLINE_OR_TAB.replaceFrom((CharSequence)text, (CharSequence)" ")).replaceAll(" ");
        StringTokenizer tokenizer = new StringTokenizer(formattedText, " ", true);
        boolean isFirstElementOnNewLineEmptyChar = false;
        while (tokenizer.hasMoreElements()) {
            String nextElement = tokenizer.nextElement().toString();
            if (lineBuilder.length() + nextElement.length() > 80) {
                for (int i = lineBuilder.length() - 1; i >= 0 && lineBuilder.charAt(i) != ' '; --i) {
                    lineBuilder.setLength(i);
                }
                while (lineBuilder.length() > 0 && lineBuilder.charAt(0) == ' ') {
                    lineBuilder.deleteCharAt(0);
                }
                sb.append((CharSequence)lineBuilder).append('\n');
                lineBuilder.setLength(0);
                if (nextLineIndent > 0) {
                    sb.append(lineIndent);
                }
                if (" ".equals(nextElement)) {
                    isFirstElementOnNewLineEmptyChar = true;
                }
            }
            if (isFirstElementOnNewLineEmptyChar) {
                isFirstElementOnNewLineEmptyChar = false;
                continue;
            }
            lineBuilder.append(nextElement);
        }
        return sb.append((CharSequence)lineBuilder).append('\n').toString();
    }
}

