/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.concepts.Immutable;

class GeneratorResult
implements Immutable {
    private static final @NonNull GeneratorResult EMPTY = new GeneratorResult();
    private final @Nullable GeneratedType generatedType;

    private GeneratorResult() {
        this.generatedType = null;
    }

    private GeneratorResult(GeneratedType generatedType) {
        this.generatedType = Objects.requireNonNull(generatedType);
    }

    static @NonNull GeneratorResult empty() {
        return EMPTY;
    }

    static @NonNull GeneratorResult member(GeneratedType generatedType) {
        return new Nested(generatedType);
    }

    static @NonNull GeneratorResult toplevel(GeneratedType generatedType) {
        return new GeneratorResult(generatedType);
    }

    final @Nullable GeneratedType generatedType() {
        return this.generatedType;
    }

    @Nullable GeneratedType enclosedType() {
        return null;
    }

    private static final class Nested
    extends GeneratorResult {
        Nested(GeneratedType generatedType) {
            super(generatedType);
        }

        @Override
        GeneratedType enclosedType() {
            return this.generatedType();
        }
    }
}

