/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import java.util.List;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeSchemaTreeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultContainerRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ContainerRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class ContainerGenerator
extends CompositeSchemaTreeGenerator<ContainerEffectiveStatement, ContainerRuntimeType> {
    ContainerGenerator(ContainerEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterDataTree((QName)((ContainerEffectiveStatement)this.statement()).argument());
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        this.addImplementsChildOf(builder);
        ContainerGenerator.addAugmentable(builder);
        this.addUsesInterfaces(builder, builderFactory);
        ContainerGenerator.addConcreteInterfaceMethods(builder);
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        this.addGetterMethods(builder, builderFactory);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        return builder.build();
    }

    @Override
    CompositeRuntimeTypeBuilder<ContainerEffectiveStatement, ContainerRuntimeType> createBuilder(ContainerEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<ContainerEffectiveStatement, ContainerRuntimeType>(statement){

            @Override
            ContainerRuntimeType build(GeneratedType type, ContainerEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
                return new DefaultContainerRuntimeType(type, statement, children, augments);
            }
        };
    }

    @Override
    MethodSignatureBuilder constructGetter(GeneratedTypeBuilderBase<?> builder, Type returnType) {
        MethodSignatureBuilder ret = super.constructGetter(builder, returnType).setMechanics(MethodSignature.ValueMechanics.NORMAL);
        if (((ContainerEffectiveStatement)this.statement()).findFirstEffectiveSubstatement(PresenceEffectiveStatement.class).isEmpty()) {
            MethodSignatureBuilder nonnull = ((MethodSignatureBuilder)builder.addMethod(BindingMapping.getNonnullMethodName((String)this.localName().getLocalName())).setReturnType(returnType)).setDefault(false);
            this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)nonnull);
        }
        return ret;
    }
}

