/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ActionGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentRequirement;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CaseGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ChoiceGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ContainerGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.FeatureGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.Generator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GeneratorContext;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.IdentityGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.InputGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.LeafGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.LeafListGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.LinkageProgress;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ListGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.MatchStrategy;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.NotificationGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.NotificationServiceGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.OpaqueObjectGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.OriginalLink;
import org.opendaylight.mdsal.binding.generator.impl.reactor.OutputGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.RpcServiceGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypedefGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.UsesAugmentGenerator;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AddedByUsesAware;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompositeGenerator<S extends EffectiveStatement<?, ?>, R extends CompositeRuntimeType>
extends AbstractExplicitGenerator<S, R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCompositeGenerator.class);
    private final @NonNull CollisionDomain domain = new CollisionDomain(this);
    private final @NonNull List<Generator> childGenerators;
    private @NonNull List<AbstractAugmentGenerator> augments = List.of();
    private List<GroupingGenerator> groupings;
    private List<AbstractCompositeGenerator<?, ?>> unlinkedComposites = List.of();
    private List<Generator> unlinkedChildren;

    AbstractCompositeGenerator(S statement) {
        super(statement);
        this.childGenerators = this.createChildren((EffectiveStatement<?, ?>)statement);
    }

    AbstractCompositeGenerator(S statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
        this.childGenerators = this.createChildren((EffectiveStatement<?, ?>)statement);
    }

    @Override
    public final Iterator<Generator> iterator() {
        return this.childGenerators.iterator();
    }

    final @NonNull List<AbstractAugmentGenerator> augments() {
        return this.augments;
    }

    final @NonNull List<GroupingGenerator> groupings() {
        return (List)Verify.verifyNotNull(this.groupings, (String)"Groupings not initialized in %s", (Object[])new Object[]{this});
    }

    @Override
    final R createExternalRuntimeType(Type type) {
        Verify.verify((boolean)(type instanceof GeneratedType), (String)"Unexpected type %s", (Object)type);
        return this.createBuilder(this.statement()).populate(new AugmentResolver(), this).build((GeneratedType)type);
    }

    abstract @NonNull CompositeRuntimeTypeBuilder<S, R> createBuilder(S var1);

    @Override
    final R createInternalRuntimeType(AugmentResolver resolver, S statement, Type type) {
        Verify.verify((boolean)(type instanceof GeneratedType), (String)"Unexpected type %s", (Object)type);
        return this.createBuilder(statement).populate(resolver, this).build((GeneratedType)type);
    }

    @Override
    final boolean isEmpty() {
        return this.childGenerators.isEmpty();
    }

    final @Nullable AbstractExplicitGenerator<?, ?> findGenerator(List<EffectiveStatement<?, ?>> stmtPath) {
        return this.findGenerator(MatchStrategy.identity(), stmtPath, 0);
    }

    final @Nullable AbstractExplicitGenerator<?, ?> findGenerator(MatchStrategy childStrategy, List<EffectiveStatement<?, ?>> stmtPath, int offset) {
        EffectiveStatement<?, ?> stmt = stmtPath.get(offset);
        AbstractExplicitGenerator<?, ?> ret = childStrategy.findGenerator(stmt, this.childGenerators);
        if (ret != null) {
            int next = offset + 1;
            if (stmtPath.size() == next) {
                return ret;
            }
            if (ret instanceof AbstractCompositeGenerator) {
                AbstractCompositeGenerator composite = (AbstractCompositeGenerator)ret;
                return composite.findGenerator(childStrategy, stmtPath, next);
            }
            return null;
        }
        if (stmt instanceof SchemaTreeEffectiveStatement) {
            for (GroupingGenerator gen : this.groupings) {
                MatchStrategy strat;
                ret = gen.findGenerator(strat = MatchStrategy.grouping(gen), stmtPath, offset);
                if (ret == null) continue;
                return ret;
            }
            MatchStrategy strat = MatchStrategy.augment();
            for (AbstractAugmentGenerator gen : this.augments) {
                ret = gen.findGenerator(strat, stmtPath, offset);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    final @NonNull CollisionDomain domain() {
        return this.domain;
    }

    final void linkUsesDependencies(GeneratorContext context) {
        ArrayList<GroupingGenerator> tmp = new ArrayList<GroupingGenerator>();
        for (EffectiveStatement stmt : this.statement().effectiveSubstatements()) {
            if (!(stmt instanceof UsesEffectiveStatement)) continue;
            UsesEffectiveStatement uses = (UsesEffectiveStatement)stmt;
            GroupingGenerator grouping = context.resolveTreeScoped(GroupingGenerator.class, (QName)uses.argument());
            tmp.add(grouping);
            for (Generator gen : this) {
                if (!(gen instanceof UsesAugmentGenerator)) continue;
                UsesAugmentGenerator usesGen = (UsesAugmentGenerator)gen;
                usesGen.resolveGrouping(uses, grouping);
            }
        }
        this.groupings = List.copyOf(tmp);
    }

    final void startUsesAugmentLinkage(List<AugmentRequirement> requirements) {
        for (Generator child : this.childGenerators) {
            if (child instanceof UsesAugmentGenerator) {
                UsesAugmentGenerator uses = (UsesAugmentGenerator)child;
                requirements.add(uses.startLinkage());
            }
            if (!(child instanceof AbstractCompositeGenerator)) continue;
            AbstractCompositeGenerator composite = (AbstractCompositeGenerator)child;
            composite.startUsesAugmentLinkage(requirements);
        }
    }

    final void addAugment(AbstractAugmentGenerator augment) {
        if (this.augments.isEmpty()) {
            this.augments = new ArrayList<AbstractAugmentGenerator>(2);
        }
        this.augments.add(Objects.requireNonNull(augment));
    }

    final @NonNull LinkageProgress linkOriginalGeneratorRecursive() {
        Iterator<Generator> it;
        if (this.unlinkedComposites == null) {
            return LinkageProgress.DONE;
        }
        if (this.unlinkedChildren == null) {
            this.unlinkedChildren = this.childGenerators.stream().filter(AbstractExplicitGenerator.class::isInstance).map(child -> (AbstractExplicitGenerator)child).collect(Collectors.toList());
        }
        LinkageProgress progress = LinkageProgress.NONE;
        if (!this.unlinkedChildren.isEmpty()) {
            it = this.unlinkedChildren.iterator();
            while (it.hasNext()) {
                AbstractExplicitGenerator explicit;
                Generator generator = it.next();
                if (!(generator instanceof AbstractExplicitGenerator) || !(explicit = (AbstractExplicitGenerator)generator).linkOriginalGenerator()) continue;
                progress = LinkageProgress.SOME;
                it.remove();
                if (!(explicit instanceof AbstractCompositeGenerator)) continue;
                AbstractCompositeGenerator composite = (AbstractCompositeGenerator)explicit;
                if (this.unlinkedComposites.isEmpty()) {
                    this.unlinkedComposites = new ArrayList();
                }
                this.unlinkedComposites.add(composite);
            }
            if (this.unlinkedChildren.isEmpty()) {
                this.unlinkedChildren = List.of();
            }
        }
        it = this.unlinkedComposites.iterator();
        while (it.hasNext()) {
            LinkageProgress tmp = ((AbstractCompositeGenerator)it.next()).linkOriginalGeneratorRecursive();
            if (tmp != LinkageProgress.NONE) {
                progress = LinkageProgress.SOME;
            }
            if (tmp != LinkageProgress.DONE) continue;
            it.remove();
        }
        if (this.unlinkedChildren.isEmpty() && this.unlinkedComposites.isEmpty()) {
            this.unlinkedComposites = null;
            return LinkageProgress.DONE;
        }
        return progress;
    }

    @Override
    final AbstractCompositeGenerator<S, R> getOriginal() {
        return (AbstractCompositeGenerator)super.getOriginal();
    }

    @Override
    final AbstractCompositeGenerator<S, R> tryOriginal() {
        return (AbstractCompositeGenerator)super.tryOriginal();
    }

    final <X extends EffectiveStatement<?, ?>, Y extends RuntimeType> @Nullable OriginalLink<X, Y> originalChild(QName childQName) {
        QName prevQName;
        AbstractExplicitGenerator<?, ?> found = this.findInferredGenerator(childQName);
        if (found != null) {
            return OriginalLink.partial(found);
        }
        AbstractExplicitGenerator prev = this.previous();
        if (prev != null && (found = prev.findSchemaTreeGenerator(prevQName = childQName.bindTo(prev.getQName().getModule()))) != null) {
            return found.originalLink();
        }
        return null;
    }

    @Override
    final AbstractExplicitGenerator<?, ?> findSchemaTreeGenerator(QName qname) {
        AbstractExplicitGenerator<?, ?> found = super.findSchemaTreeGenerator(qname);
        return found != null ? found : this.findInferredGenerator(qname);
    }

    final @Nullable AbstractAugmentGenerator findAugmentForGenerator(QName qname) {
        for (AbstractAugmentGenerator augment : this.augments) {
            AbstractExplicitGenerator<?, ?> gen = augment.findSchemaTreeGenerator(qname);
            if (gen == null) continue;
            return augment;
        }
        return null;
    }

    final @Nullable GroupingGenerator findGroupingForGenerator(QName qname) {
        for (GroupingGenerator grouping : this.groupings) {
            AbstractExplicitGenerator<?, ?> gen = grouping.findSchemaTreeGenerator(qname.bindTo(((QName)((GroupingEffectiveStatement)grouping.statement()).argument()).getModule()));
            if (gen == null) continue;
            return grouping;
        }
        return null;
    }

    private @Nullable AbstractExplicitGenerator<?, ?> findInferredGenerator(QName qname) {
        AbstractExplicitGenerator<?, ?> gen;
        for (GroupingGenerator grouping : this.groupings) {
            gen = grouping.findSchemaTreeGenerator(qname.bindTo(((QName)((GroupingEffectiveStatement)grouping.statement()).argument()).getModule()));
            if (gen == null) continue;
            return gen;
        }
        for (AbstractAugmentGenerator augment : this.augments) {
            gen = augment.findSchemaTreeGenerator(qname);
            if (gen == null) continue;
            return gen;
        }
        return null;
    }

    final int addUsesInterfaces(GeneratedTypeBuilder builder, TypeBuilderFactory builderFactory) {
        for (GroupingGenerator grp : this.groupings) {
            builder.addImplementsType((Type)grp.getGeneratedType(builderFactory));
        }
        return this.groupings.size();
    }

    static final void addAugmentable(GeneratedTypeBuilder builder) {
        builder.addImplementsType((Type)BindingTypes.augmentable((Type)builder));
    }

    final void addGetterMethods(GeneratedTypeBuilder builder, TypeBuilderFactory builderFactory) {
        for (Generator child : this) {
            GeneratedType enclosedType;
            if (child instanceof AbstractExplicitGenerator) {
                AbstractExplicitGenerator explicit = (AbstractExplicitGenerator)child;
                explicit.addAsGetterMethod((GeneratedTypeBuilderBase<?>)builder, builderFactory);
            }
            if ((enclosedType = child.enclosedType(builderFactory)) instanceof GeneratedTransferObject) {
                GeneratedTransferObject gto = (GeneratedTransferObject)enclosedType;
                builder.addEnclosingTransferObject(gto);
                continue;
            }
            if (enclosedType instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)enclosedType;
                builder.addEnumeration(enumeration);
                continue;
            }
            Verify.verify((enclosedType == null ? 1 : 0) != 0, (String)"Unhandled enclosed type %s in %s", (Object)enclosedType, (Object)child);
        }
    }

    private @NonNull List<Generator> createChildren(EffectiveStatement<?, ?> statement) {
        Object stmt2;
        ArrayList<Generator> tmp = new ArrayList<Generator>();
        ArrayList<? super AbstractAugmentGenerator> tmpAug = new ArrayList<AbstractAugmentGenerator>();
        for (Object stmt2 : statement.effectiveSubstatements()) {
            ModuleGenerator module;
            AbstractExplicitGenerator keyGen;
            if (stmt2 instanceof ActionEffectiveStatement) {
                ActionEffectiveStatement action = (ActionEffectiveStatement)stmt2;
                if (AbstractCompositeGenerator.isAugmenting(action)) continue;
                tmp.add(new ActionGenerator(action, this));
                continue;
            }
            if (stmt2 instanceof AnydataEffectiveStatement) {
                AnydataEffectiveStatement anydata = (AnydataEffectiveStatement)stmt2;
                if (AbstractCompositeGenerator.isAugmenting(anydata)) continue;
                tmp.add(new OpaqueObjectGenerator.Anydata(anydata, this));
                continue;
            }
            if (stmt2 instanceof AnyxmlEffectiveStatement) {
                AnyxmlEffectiveStatement anyxml = (AnyxmlEffectiveStatement)stmt2;
                if (AbstractCompositeGenerator.isAugmenting(anyxml)) continue;
                tmp.add(new OpaqueObjectGenerator.Anyxml(anyxml, this));
                continue;
            }
            if (stmt2 instanceof CaseEffectiveStatement) {
                CaseEffectiveStatement cast = (CaseEffectiveStatement)stmt2;
                tmp.add(new CaseGenerator(cast, this));
                continue;
            }
            if (stmt2 instanceof ChoiceEffectiveStatement) {
                ChoiceEffectiveStatement choice = (ChoiceEffectiveStatement)stmt2;
                if (AbstractCompositeGenerator.isAddedByUses(choice)) continue;
                tmp.add(new ChoiceGenerator(choice, this));
                continue;
            }
            if (stmt2 instanceof ContainerEffectiveStatement) {
                ContainerEffectiveStatement container = (ContainerEffectiveStatement)stmt2;
                if (!AbstractCompositeGenerator.isOriginalDeclaration(container)) continue;
                tmp.add(new ContainerGenerator(container, this));
                continue;
            }
            if (stmt2 instanceof FeatureEffectiveStatement) {
                FeatureEffectiveStatement feature = (FeatureEffectiveStatement)stmt2;
                AbstractCompositeGenerator abstractCompositeGenerator = this;
                if (abstractCompositeGenerator instanceof ModuleGenerator) {
                    ModuleGenerator parent = (ModuleGenerator)abstractCompositeGenerator;
                    tmp.add(new FeatureGenerator(feature, parent));
                    continue;
                }
            }
            if (stmt2 instanceof GroupingEffectiveStatement) {
                GroupingEffectiveStatement grouping = (GroupingEffectiveStatement)stmt2;
                tmp.add(new GroupingGenerator(grouping, this));
                continue;
            }
            if (stmt2 instanceof IdentityEffectiveStatement) {
                IdentityEffectiveStatement identity = (IdentityEffectiveStatement)stmt2;
                tmp.add(new IdentityGenerator(identity, this));
                continue;
            }
            if (stmt2 instanceof InputEffectiveStatement) {
                InputEffectiveStatement input = (InputEffectiveStatement)stmt2;
                tmp.add(new InputGenerator(input, this));
                continue;
            }
            if (stmt2 instanceof LeafEffectiveStatement) {
                LeafEffectiveStatement leaf = (LeafEffectiveStatement)stmt2;
                if (AbstractCompositeGenerator.isAugmenting(leaf)) continue;
                tmp.add(new LeafGenerator(leaf, this));
                continue;
            }
            if (stmt2 instanceof LeafListEffectiveStatement) {
                LeafListEffectiveStatement leafList = (LeafListEffectiveStatement)stmt2;
                if (AbstractCompositeGenerator.isAugmenting(leafList)) continue;
                tmp.add(new LeafListGenerator(leafList, this));
                continue;
            }
            if (stmt2 instanceof ListEffectiveStatement) {
                ListEffectiveStatement list = (ListEffectiveStatement)stmt2;
                if (!AbstractCompositeGenerator.isOriginalDeclaration(list)) continue;
                ListGenerator listGen = new ListGenerator(list, this);
                tmp.add(listGen);
                keyGen = listGen.keyGenerator();
                if (keyGen == null) continue;
                tmp.add(keyGen);
                continue;
            }
            if (stmt2 instanceof NotificationEffectiveStatement) {
                NotificationEffectiveStatement notification = (NotificationEffectiveStatement)stmt2;
                if (AbstractCompositeGenerator.isAugmenting(notification)) continue;
                tmp.add(new NotificationGenerator(notification, this));
                continue;
            }
            if (stmt2 instanceof OutputEffectiveStatement) {
                OutputEffectiveStatement output = (OutputEffectiveStatement)stmt2;
                tmp.add(new OutputGenerator(output, this));
                continue;
            }
            if (stmt2 instanceof RpcEffectiveStatement) {
                RpcEffectiveStatement rpc = (RpcEffectiveStatement)stmt2;
                keyGen = this;
                if (!(keyGen instanceof ModuleGenerator)) continue;
                module = (ModuleGenerator)keyGen;
                tmp.add(new RpcGenerator(rpc, module));
                continue;
            }
            if (stmt2 instanceof TypedefEffectiveStatement) {
                TypedefEffectiveStatement typedef = (TypedefEffectiveStatement)stmt2;
                tmp.add(new TypedefGenerator(typedef, this));
                continue;
            }
            if (stmt2 instanceof AugmentEffectiveStatement) {
                AugmentEffectiveStatement augment = (AugmentEffectiveStatement)stmt2;
                keyGen = this;
                if (!(keyGen instanceof ModuleGenerator)) continue;
                module = (ModuleGenerator)keyGen;
                tmpAug.add(new ModuleAugmentGenerator(augment, module));
                continue;
            }
            if (stmt2 instanceof UsesEffectiveStatement) {
                UsesEffectiveStatement uses = (UsesEffectiveStatement)stmt2;
                for (EffectiveStatement usesSub : uses.effectiveSubstatements()) {
                    if (!(usesSub instanceof AugmentEffectiveStatement)) continue;
                    AugmentEffectiveStatement usesAug = (AugmentEffectiveStatement)usesSub;
                    tmpAug.add(new UsesAugmentGenerator(usesAug, uses, this));
                }
                continue;
            }
            LOG.trace("Ignoring statement {}", stmt2);
        }
        tmpAug.sort(AbstractAugmentGenerator.COMPARATOR);
        tmp.addAll(tmpAug);
        stmt2 = this;
        if (stmt2 instanceof ModuleGenerator) {
            ModuleGenerator moduleGen = (ModuleGenerator)stmt2;
            List<NotificationGenerator> notifs = tmp.stream().filter(NotificationGenerator.class::isInstance).map(NotificationGenerator.class::cast).collect(Collectors.toUnmodifiableList());
            if (!notifs.isEmpty()) {
                tmp.add(new NotificationServiceGenerator(moduleGen, notifs));
            }
            List<RpcGenerator> rpcs = tmp.stream().filter(RpcGenerator.class::isInstance).map(RpcGenerator.class::cast).collect(Collectors.toUnmodifiableList());
            if (!rpcs.isEmpty()) {
                tmp.add(new RpcServiceGenerator(moduleGen, rpcs));
            }
        }
        return List.copyOf(tmp);
    }

    private static boolean isOriginalDeclaration(EffectiveStatement<?, ?> stmt) {
        CopyableNode copyable;
        AddedByUsesAware aware;
        return !(stmt instanceof AddedByUsesAware) || !(aware = (AddedByUsesAware)stmt).isAddedByUses() && (!(stmt instanceof CopyableNode) || !(copyable = (CopyableNode)stmt).isAugmenting());
    }

    private static boolean isAddedByUses(EffectiveStatement<?, ?> stmt) {
        AddedByUsesAware aware;
        return stmt instanceof AddedByUsesAware && (aware = (AddedByUsesAware)stmt).isAddedByUses();
    }

    private static boolean isAugmenting(EffectiveStatement<?, ?> stmt) {
        CopyableNode copyable;
        return stmt instanceof CopyableNode && (copyable = (CopyableNode)stmt).isAugmenting();
    }
}

