/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.BindingGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.Generator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.GeneratorReactor;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementEquivalent;
import org.opendaylight.yangtools.yang.model.api.Module;

public final class DefaultBindingGenerator
implements BindingGenerator {
    @Override
    public List<GeneratedType> generateTypes(EffectiveModelContext context, Collection<? extends Module> modules) {
        return DefaultBindingGenerator.generateFor(context, modules);
    }

    @VisibleForTesting
    static @NonNull List<GeneratedType> generateFor(EffectiveModelContext context) {
        return DefaultBindingGenerator.generateFor(context, context.getModules());
    }

    @VisibleForTesting
    static @NonNull List<GeneratedType> generateFor(EffectiveModelContext context, Collection<? extends Module> modules) {
        Set filter = modules.stream().map(EffectiveStatementEquivalent::asEffectiveStatement).collect(Collectors.toUnmodifiableSet());
        ArrayList<GeneratedType> result = new ArrayList<GeneratedType>();
        for (ModuleGenerator gen : new GeneratorReactor(context).execute(TypeBuilderFactory.codegen()).values()) {
            if (!filter.contains(gen.statement())) continue;
            DefaultBindingGenerator.addTypes(result, gen);
        }
        return result;
    }

    private static void addTypes(List<GeneratedType> result, Generator gen) {
        gen.generatedType().filter(type -> ((JavaTypeName)type.getIdentifier()).immediatelyEnclosingClass().isEmpty()).ifPresent(result::add);
        result.addAll(gen.auxiliaryGeneratedTypes());
        for (Generator child : gen) {
            DefaultBindingGenerator.addTypes(result, child);
        }
    }
}

