/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.osgi;

import com.google.common.base.Verify;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAdaptedService<B extends BindingService> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAdaptedService.class);
    static final @NonNull String DELEGATE = "org.opendaylight.mdsal.binding.dom.adapter.osgi.AbstractAdaptedService.DELEGATE";
    private final String serviceName;
    final @NonNull B delegate;

    AbstractAdaptedService(Class<B> bindingService, Map<String, ?> properties) {
        this.serviceName = bindingService.getSimpleName();
        this.delegate = (BindingService)bindingService.cast(Verify.verifyNotNull(properties.get(DELEGATE)));
        LOG.info("Binding/DOM adapter for {} activated", (Object)this.serviceName);
    }

    final void stop(int reason) {
        LOG.info("Binding/DOM adapter for {} deactivated (reason {})", (Object)this.serviceName, (Object)reason);
    }
}

