/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractDataObjectModification;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataObjectModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.data.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

final class LazyDataTreeModification<T extends DataObject>
implements DataTreeModification<T> {
    private final @NonNull LogicalDatastoreType datastore;
    private final @NonNull DataObjectIdentifier<T> path;
    private final @NonNull DataObjectModification<T> rootNode;

    private LazyDataTreeModification(LogicalDatastoreType datastore, DataObjectIdentifier<T> path, DataObjectModification<T> modification) {
        this.datastore = Objects.requireNonNull(datastore);
        this.path = Objects.requireNonNull(path);
        this.rootNode = Objects.requireNonNull(modification);
    }

    static <T extends DataObject> @Nullable DataTreeModification<T> from(CurrentAdapterSerializer serializer, DataTreeCandidate domChange, LogicalDatastoreType datastoreType, @Nullable Class<? extends Augmentation<?>> augment) {
        InstanceIdentifier<? extends Augmentation<?>> bindingPath = LazyDataTreeModification.createBindingPath(serializer, domChange.getRootPath(), augment);
        CommonDataObjectCodecTreeNode codec = serializer.getSubtreeCodec((DataObjectReference)bindingPath);
        AbstractDataObjectModification<?, ?> modification = LazyDataObjectModification.from(codec, domChange.getRootNode());
        return modification == null ? null : new LazyDataTreeModification<T>(datastoreType, bindingPath.toIdentifier(), modification);
    }

    static <T extends DataObject> @Nullable DataTreeModification<T> from(CurrentAdapterSerializer serializer, DOMDataTreeCandidate candidate, @Nullable Class<T> augment) {
        DOMDataTreeIdentifier domRootPath = candidate.getRootPath();
        InstanceIdentifier<T> bindingPath = LazyDataTreeModification.createBindingPath(serializer, domRootPath.path(), augment);
        CommonDataObjectCodecTreeNode codec = serializer.getSubtreeCodec((DataObjectReference)bindingPath);
        AbstractDataObjectModification<?, ?> modification = LazyDataObjectModification.from(codec, candidate.getRootNode());
        return modification == null ? null : new LazyDataTreeModification<T>(domRootPath.datastore(), bindingPath.toIdentifier(), modification);
    }

    static <T extends DataObject> @NonNull List<DataTreeModification<T>> from(CurrentAdapterSerializer codec, List<DataTreeCandidate> domChanges, LogicalDatastoreType datastoreType, @Nullable Class<? extends Augmentation<?>> augment) {
        ArrayList<DataTreeModification<T>> result = new ArrayList<DataTreeModification<T>>(domChanges.size());
        for (DataTreeCandidate domChange : domChanges) {
            DataTreeModification<T> bindingChange = LazyDataTreeModification.from(codec, domChange, datastoreType, augment);
            if (bindingChange == null) continue;
            result.add(bindingChange);
        }
        return result;
    }

    private static @NonNull InstanceIdentifier<?> createBindingPath(CurrentAdapterSerializer serializer, YangInstanceIdentifier domPath, @Nullable Class<?> augment) {
        InstanceIdentifier bindingPath = serializer.coerceInstanceIdentifier(domPath).toLegacy();
        return augment == null ? bindingPath : bindingPath.augmentation(augment.asSubclass(Augmentation.class));
    }

    public LogicalDatastoreType datastore() {
        return this.datastore;
    }

    public DataObjectIdentifier<T> path() {
        return this.path;
    }

    public DataObjectModification<T> getRootNode() {
        return this.rootNode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.getRootPath()).add("rootNode", this.rootNode).toString();
    }
}

