/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.ActionSpec;
import org.opendaylight.mdsal.binding.api.InstanceNotificationSpec;
import org.opendaylight.mdsal.binding.dom.adapter.ContextReferenceExtractor;
import org.opendaylight.yangtools.binding.BindingContract;
import org.opendaylight.yangtools.binding.BindingInstanceIdentifier;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.data.codec.spi.BindingDOMCodecServices;
import org.opendaylight.yangtools.binding.data.codec.spi.ForwardingBindingDOMCodecServices;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.runtime.api.ActionRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.InputRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.NotificationRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

@Beta
@VisibleForTesting
public final class CurrentAdapterSerializer
extends ForwardingBindingDOMCodecServices {
    private final LoadingCache<BindingInstanceIdentifier, YangInstanceIdentifier> cache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<BindingInstanceIdentifier, YangInstanceIdentifier>(){

        public YangInstanceIdentifier load(BindingInstanceIdentifier key) {
            return CurrentAdapterSerializer.this.getInstanceIdentifierCodec().fromBinding(key);
        }
    });
    private final ConcurrentMap<JavaTypeName, ContextReferenceExtractor> extractors = new ConcurrentHashMap<JavaTypeName, ContextReferenceExtractor>();
    private final @NonNull BindingDOMCodecServices delegate;

    public CurrentAdapterSerializer(BindingDOMCodecServices delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected BindingDOMCodecServices delegate() {
        return this.delegate;
    }

    @NonNull YangInstanceIdentifier toCachedYangInstanceIdentifier(@NonNull BindingInstanceIdentifier path) {
        return (YangInstanceIdentifier)this.cache.getUnchecked((Object)path);
    }

    <T extends DataObject> @NonNull DataObjectReference<T> coerceInstanceIdentifier(YangInstanceIdentifier dom) {
        return (DataObjectReference)Verify.verifyNotNull((Object)this.fromYangInstanceIdentifier(dom));
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute getActionPath(@NonNull ActionSpec<?, ?> spec) {
        return this.getSchemaNodeIdentifier(spec.path(), spec.type(), ActionRuntimeType.class, ActionEffectiveStatement.class);
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute getNotificationPath(@NonNull InstanceNotificationSpec<?, ?> spec) {
        return this.getSchemaNodeIdentifier(spec.path(), spec.type(), NotificationRuntimeType.class, NotificationEffectiveStatement.class);
    }

    private <T extends RuntimeType> // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute getSchemaNodeIdentifier(@NonNull DataObjectReference<?> path, @NonNull Class<? extends BindingContract<?>> type, @NonNull Class<T> expectedRuntime, @NonNull Class<? extends SchemaTreeEffectiveStatement<?>> expectedStatement) {
        RuntimeType casted;
        JavaTypeName typeName = JavaTypeName.create(type);
        RuntimeType runtimeType = (RuntimeType)this.getRuntimeContext().getTypes().findSchema(typeName).orElseThrow(() -> new IllegalArgumentException(String.valueOf(typeName) + " is not known"));
        try {
            casted = (RuntimeType)expectedRuntime.cast(runtimeType);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.valueOf(typeName) + " resolved to unexpected " + String.valueOf(runtimeType), e);
        }
        QName qname = (QName)expectedStatement.cast(casted.statement()).argument();
        Map.Entry<SchemaInferenceStack, QNameModule> entry = this.resolvePath(path);
        SchemaInferenceStack stack = entry.getKey();
        SchemaTreeEffectiveStatement stmt = stack.enterSchemaTree(qname.bindTo(entry.getValue()));
        if (expectedStatement.isInstance(stmt)) {
            return stack.toSchemaNodeIdentifier();
        }
        throw new VerifyException(String.valueOf(path) + " child " + String.valueOf(typeName) + " resolved to unexpected statement" + String.valueOf(stmt));
    }

    @Nullable ContextReferenceExtractor findExtractor(@NonNull InputRuntimeType inputType) {
        Class inputClass;
        JavaTypeName inputName = inputType.getIdentifier();
        ContextReferenceExtractor cached = (ContextReferenceExtractor)this.extractors.get(inputName);
        if (cached != null) {
            return cached;
        }
        try {
            inputClass = this.getRuntimeContext().loadClass(inputName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to load class for " + String.valueOf(inputType), e);
        }
        ContextReferenceExtractor created = ContextReferenceExtractor.of(inputClass);
        if (created == null) {
            return null;
        }
        ContextReferenceExtractor raced = this.extractors.putIfAbsent(inputName, created);
        return raced != null ? raced : created;
    }

    private @NonNull Map.Entry<SchemaInferenceStack, QNameModule> resolvePath(@NonNull DataObjectReference<?> path) {
        QNameModule lastNamespace;
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)this.getRuntimeContext().modelContext());
        Iterator it = this.toYangInstanceIdentifier(path).getPathArguments().iterator();
        Verify.verify((boolean)it.hasNext(), (String)"Unexpected empty instance identifier for %s", path);
        do {
            YangInstanceIdentifier.PathArgument arg = (YangInstanceIdentifier.PathArgument)it.next();
            QName qname = arg.getNodeType();
            DataTreeEffectiveStatement stmt = stack.enterDataTree(qname);
            lastNamespace = qname.getModule();
            if (!(stmt instanceof ListEffectiveStatement)) continue;
            Verify.verify((boolean)it.hasNext(), (String)"Unexpected list termination at %s in %s", (Object)stmt, path);
            YangInstanceIdentifier.PathArgument skipped = (YangInstanceIdentifier.PathArgument)it.next();
            Verify.verify((boolean)(skipped instanceof YangInstanceIdentifier.NodeIdentifier), (String)"Unexpected skipped list entry item %s in %s", (Object)skipped, path);
            Verify.verify((boolean)((QName)stmt.argument()).equals((Object)skipped.getNodeType()), (String)"Mismatched list entry item %s in %s", (Object)skipped, path);
        } while (it.hasNext());
        return Map.entry(stack, lastNamespace);
    }
}

