/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcImplementationAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.yangtools.binding.BindingInstanceIdentifier;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.yangtools.binding.runtime.api.RpcRuntimeType;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@VisibleForTesting
public class BindingDOMRpcProviderServiceAdapter
extends AbstractBindingAdapter<DOMRpcProviderService>
implements RpcProviderService {
    private static final ImmutableSet<YangInstanceIdentifier> GLOBAL = ImmutableSet.of((Object)YangInstanceIdentifier.of());

    public BindingDOMRpcProviderServiceAdapter(AdapterContext adapterContext, DOMRpcProviderService domRpcRegistry) {
        super(adapterContext, domRpcRegistry);
    }

    public Registration registerRpcImplementation(Rpc<?, ?> implementation) {
        return this.register(this.currentSerializer(), (Rpc)implementation, (Collection<YangInstanceIdentifier>)GLOBAL);
    }

    public Registration registerRpcImplementation(Rpc<?, ?> implementation, Set<DataObjectIdentifier<?>> paths) {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        return this.register(serializer, implementation, BindingDOMRpcProviderServiceAdapter.toYangInstanceIdentifiers(serializer, paths));
    }

    public Registration registerRpcImplementations(Collection<Rpc<?, ?>> implementations) {
        return this.register(this.currentSerializer(), implementations, (Collection<YangInstanceIdentifier>)GLOBAL);
    }

    public Registration registerRpcImplementations(Collection<Rpc<?, ?>> implementations, Set<DataObjectIdentifier<?>> paths) {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        return this.register(serializer, implementations, BindingDOMRpcProviderServiceAdapter.toYangInstanceIdentifiers(serializer, paths));
    }

    @Deprecated(since="13.0.1")
    public Registration registerRpcImplementations(ClassToInstanceMap<Rpc<?, ?>> implementations) {
        return this.registerRpcImplementations(implementations.values());
    }

    @Deprecated(since="13.0.1")
    public Registration registerRpcImplementations(ClassToInstanceMap<Rpc<?, ?>> implementations, Set<DataObjectIdentifier<?>> paths) {
        return this.registerRpcImplementations(implementations.values(), paths);
    }

    private <T extends Rpc<?, ?>> @NonNull Registration register(CurrentAdapterSerializer serializer, T implementation, Collection<YangInstanceIdentifier> rpcContextPaths) {
        return this.register(serializer, List.of(implementation), rpcContextPaths);
    }

    private @NonNull Registration register(CurrentAdapterSerializer serializer, Collection<Rpc<?, ?>> implementations, Collection<YangInstanceIdentifier> rpcContextPaths) {
        BindingRuntimeContext context = serializer.getRuntimeContext();
        return this.register(implementations, rpcContextPaths, (T impl) -> {
            Class type = impl.implementedInterface();
            RpcRuntimeType def = context.getRpcDefinition(type);
            if (def == null) {
                throw new IllegalArgumentException("Cannot resolve YANG definition of " + String.valueOf(type));
            }
            QName rpcName = (QName)def.statement().argument();
            return new Impl(rpcName, new BindingDOMRpcImplementationAdapter(this.adapterContext(), rpcName, (Rpc<?, ?>)impl));
        });
    }

    private <T> @NonNull Registration register(Collection<T> impls, Collection<YangInstanceIdentifier> paths, Function<T, Impl> implFactory) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)impls.size());
        for (T impl : impls) {
            Impl proxyImpl = implFactory.apply(impl);
            paths.forEach(path -> builder.put((Object)DOMRpcIdentifier.create((QName)proxyImpl.qname, (YangInstanceIdentifier)path), (Object)proxyImpl.impl));
        }
        return ((DOMRpcProviderService)this.getDelegate()).registerRpcImplementations((Map)builder.build());
    }

    private static List<YangInstanceIdentifier> toYangInstanceIdentifiers(CurrentAdapterSerializer serializer, Set<DataObjectIdentifier<?>> identifiers) {
        return identifiers.stream().map(binding -> serializer.toCachedYangInstanceIdentifier((BindingInstanceIdentifier)binding)).collect(Collectors.toList());
    }

    private record Impl(@NonNull QName qname, @NonNull DOMRpcImplementation impl) {
    }
}

