/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.LazySerializedNotification;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeSerializer;

@VisibleForTesting
public final class BindingDOMNotificationPublishServiceAdapter
extends AbstractBindingAdapter<DOMNotificationPublishService>
implements NotificationPublishService {
    static final BindingDOMAdapterBuilder.Factory<NotificationPublishService> BUILDER_FACTORY = Builder::new;

    public BindingDOMNotificationPublishServiceAdapter(AdapterContext adapterContext, DOMNotificationPublishService domPublishService) {
        super(adapterContext, domPublishService);
    }

    public void putNotification(Notification<?> notification) throws InterruptedException {
        ((DOMNotificationPublishService)this.getDelegate()).putNotification(this.toDomNotification(notification));
    }

    public ListenableFuture<? extends Object> offerNotification(Notification<?> notification) {
        return BindingDOMNotificationPublishServiceAdapter.toBindingResult((ListenableFuture<? extends Object>)((DOMNotificationPublishService)this.getDelegate()).offerNotification(this.toDomNotification(notification)));
    }

    public ListenableFuture<? extends Object> offerNotification(Notification<?> notification, int timeout, TimeUnit unit) throws InterruptedException {
        return BindingDOMNotificationPublishServiceAdapter.toBindingResult((ListenableFuture<? extends Object>)((DOMNotificationPublishService)this.getDelegate()).offerNotification(this.toDomNotification(notification), (long)timeout, unit));
    }

    private @NonNull DOMNotification toDomNotification(Notification<?> notification) {
        return new LazySerializedNotification((BindingNormalizedNodeSerializer)this.currentSerializer(), notification);
    }

    private static @NonNull ListenableFuture<? extends Object> toBindingResult(@NonNull ListenableFuture<? extends Object> domResult) {
        return DOMNotificationPublishService.REJECTED.equals(domResult) ? NotificationPublishService.REJECTED : domResult;
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<NotificationPublishService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        public Set<Class<? extends DOMService<?, ?>>> getRequiredDelegates() {
            return ImmutableSet.of(DOMNotificationPublishService.class);
        }

        @Override
        protected NotificationPublishService createInstance(ClassToInstanceMap<DOMService<?, ?>> delegates) {
            return new BindingDOMNotificationPublishServiceAdapter(this.adapterContext(), (DOMNotificationPublishService)delegates.getInstance(DOMNotificationPublishService.class));
        }
    }
}

