/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Verify;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazySerializedNotification;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.yangtools.binding.BaseNotification;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.binding.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

final class BindingDOMNotificationListenerAdapter<N extends Notification<N> & DataObject>
implements DOMNotificationListener {
    private final AdapterContext adapterContext;
    private final NotificationService.Listener<N> delegate;
    private final Executor executor;
    private final Class<N> type;

    BindingDOMNotificationListenerAdapter(AdapterContext adapterContext, Class<N> type, NotificationService.Listener<N> delegate, Executor executor) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.type = Objects.requireNonNull(type);
        this.delegate = Objects.requireNonNull(delegate);
        this.executor = Objects.requireNonNull(executor);
    }

    BindingDOMNotificationListenerAdapter(AdapterContext adapterContext, NotificationService.CompositeListener.Component<N> component, Executor executor) {
        this(adapterContext, component.type(), component.listener(), executor);
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute schemaPath() {
        return SchemaNodeIdentifier.Absolute.of((QName)BindingReflections.findQName(this.type));
    }

    public void onNotification(DOMNotification notification) {
        Notification binding = (Notification)this.type.cast(Verify.verifyNotNull(this.deserialize(notification)));
        this.executor.execute(() -> this.delegate.onNotification(binding));
    }

    private Notification<?> deserialize(DOMNotification notification) {
        BaseNotification baseNotification;
        if (notification instanceof LazySerializedNotification) {
            LazySerializedNotification lazy = (LazySerializedNotification)notification;
            return (Notification)lazy.getBindingData();
        }
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        if (notification instanceof DOMEvent) {
            DOMEvent domEvent = (DOMEvent)notification;
            baseNotification = serializer.fromNormalizedNodeNotification(notification.getType(), notification.getBody(), domEvent.getEventInstant());
        } else {
            baseNotification = serializer.fromNormalizedNodeNotification(notification.getType(), notification.getBody());
        }
        BaseNotification result = baseNotification;
        Verify.verify((boolean)(result instanceof Notification), (String)"Unexpected codec result %s", (Object)result);
        return (Notification)result;
    }
}

