/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.ActionSpec;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcFutureAware;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.RpcResultUtil;
import org.opendaylight.mdsal.binding.dom.adapter.StaticConfiguration;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

final class ActionAdapter
extends AbstractBindingAdapter<DOMActionService>
implements InvocationHandler {
    private final @NonNull ActionSpec<?, ?> spec;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier inputName;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute actionPath;

    ActionAdapter(AdapterContext codec, DOMActionService delegate, ActionSpec<?, ?> spec) {
        super(codec, delegate);
        this.spec = Objects.requireNonNull(spec);
        this.actionPath = this.currentSerializer().getActionPath(spec);
        this.inputName = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.operationInputQName((QNameModule)this.actionPath.lastNodeIdentifier().getModule()));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "equals": {
                if (args.length != 1) break;
                return proxy == args[0];
            }
            case "hashCode": {
                if (args.length != 0) break;
                return System.identityHashCode(proxy);
            }
            case "toString": {
                if (args.length != 0) break;
                return this.spec.type().getName() + "$Adapter{delegate=" + String.valueOf(this.getDelegate()) + "}";
            }
            case "invoke": {
                if (args.length != 2) break;
                DataObjectIdentifier path = (DataObjectIdentifier)Objects.requireNonNull(args[0]);
                RpcInput input = (RpcInput)Objects.requireNonNull(args[1]);
                CurrentAdapterSerializer serializer = this.currentSerializer();
                ListenableFuture future = ((DOMActionService)this.getDelegate()).invokeAction(this.actionPath, DOMDataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (YangInstanceIdentifier)serializer.toYangInstanceIdentifier((DataObjectReference)path)), (ContainerNode)serializer.toLazyNormalizedNodeActionInput(this.spec.type(), this.inputName, input));
                if (StaticConfiguration.ENABLE_CODEC_SHORTCUT && future instanceof BindingRpcFutureAware) {
                    BindingRpcFutureAware bindingAware = (BindingRpcFutureAware)future;
                    return bindingAware.getBindingFuture();
                }
                Class specType = this.spec.type();
                return Futures.transform((ListenableFuture)future, dom -> {
                    ContainerNode value = dom.value();
                    return RpcResultUtil.rpcResultFromDOM(dom.errors(), value == null ? null : serializer.fromNormalizedNodeActionOutput(specType, value));
                }, (Executor)MoreExecutors.directExecutor());
            }
        }
        if (method.isDefault()) {
            return InvocationHandler.invokeDefault(proxy, method, args);
        }
        throw new NoSuchMethodError("Method " + method.toString() + "is unsupported.");
    }
}

