/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcFutureAware;
import org.opendaylight.mdsal.binding.dom.adapter.ContextReferenceExtractor;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazySerializedContainerNode;
import org.opendaylight.mdsal.binding.dom.adapter.RpcAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.RpcResultUtil;
import org.opendaylight.mdsal.binding.dom.adapter.StaticConfiguration;
import org.opendaylight.yangtools.binding.BindingInstanceIdentifier;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.RpcInput;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

sealed class RpcInvocationStrategy {
    private final @NonNull RpcAdapter adapter;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier inputIdentifier;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Absolute outputPath;

    RpcInvocationStrategy(RpcAdapter adapter, QName rpcName) {
        this.adapter = Objects.requireNonNull(adapter);
        QNameModule namespace = rpcName.getModule();
        this.outputPath = SchemaNodeIdentifier.Absolute.of((QName[])new QName[]{rpcName, YangConstants.operationOutputQName((QNameModule)namespace).intern()}).intern();
        this.inputIdentifier = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.operationInputQName((QNameModule)namespace.intern()));
    }

    final ListenableFuture<RpcResult<?>> invoke(RpcInput input) {
        CurrentAdapterSerializer serializer = this.adapter.currentSerializer();
        return this.invoke(serializer, this.serialize(this.inputIdentifier, serializer, input));
    }

    private ListenableFuture<RpcResult<?>> invoke(@NonNull CurrentAdapterSerializer serializer, ContainerNode input) {
        ListenableFuture domFuture = this.adapter.delegate().invokeRpc(this.outputPath.firstNodeIdentifier(), input);
        if (StaticConfiguration.ENABLE_CODEC_SHORTCUT && domFuture instanceof BindingRpcFutureAware) {
            BindingRpcFutureAware bindingAware = (BindingRpcFutureAware)domFuture;
            return bindingAware.getBindingFuture();
        }
        return Futures.transform((ListenableFuture)domFuture, dom -> {
            ContainerNode value = dom.value();
            return RpcResultUtil.rpcResultFromDOM(dom.errors(), value == null ? null : serializer.fromNormalizedNodeRpcData(this.outputPath, value));
        }, (Executor)MoreExecutors.directExecutor());
    }

    ContainerNode serialize(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier identifier, @NonNull CurrentAdapterSerializer serializer, RpcInput input) {
        return LazySerializedContainerNode.create(this.inputIdentifier, (DataObject)input, (BindingNormalizedNodeSerializer)serializer);
    }

    static final class ContentRouted
    extends RpcInvocationStrategy {
        private final ContextReferenceExtractor refExtractor;
        private final YangInstanceIdentifier.NodeIdentifier contextName;

        ContentRouted(RpcAdapter adapter, QName rpcName, QName leafName, ContextReferenceExtractor refExtractor) {
            super(adapter, rpcName);
            this.contextName = YangInstanceIdentifier.NodeIdentifier.create((QName)leafName);
            this.refExtractor = Objects.requireNonNull(refExtractor);
        }

        @Override
        ContainerNode serialize(YangInstanceIdentifier.NodeIdentifier inputIdentifier, CurrentAdapterSerializer serializer, RpcInput input) {
            BindingInstanceIdentifier bindingII = this.refExtractor.extract((DataObject)input);
            if (bindingII == null) {
                return super.serialize(inputIdentifier, serializer, input);
            }
            YangInstanceIdentifier yangII = serializer.toCachedYangInstanceIdentifier(bindingII);
            LeafNode contextRef = ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)this.contextName, (Object)yangII);
            return LazySerializedContainerNode.withContextRef(inputIdentifier, (DataObject)input, contextRef, (BindingNormalizedNodeSerializer)serializer);
        }
    }
}

