/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.Beta;
import java.util.Iterator;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnydataNode;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;

@Beta
public enum BindingStructuralType {
    NOT_ADDRESSABLE,
    INVISIBLE_CONTAINER,
    INVISIBLE_LIST,
    VISIBLE_CONTAINER,
    UNKNOWN;


    public static BindingStructuralType from(DataTreeCandidateNode domChildNode) {
        NormalizedNode dataBased = domChildNode.dataAfter();
        if (dataBased == null) {
            dataBased = domChildNode.dataBefore();
        }
        return dataBased != null ? BindingStructuralType.from(dataBased) : BindingStructuralType.from(domChildNode.name());
    }

    private static BindingStructuralType from(YangInstanceIdentifier.PathArgument identifier) {
        if (identifier instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            return VISIBLE_CONTAINER;
        }
        if (identifier instanceof YangInstanceIdentifier.NodeWithValue) {
            return NOT_ADDRESSABLE;
        }
        return UNKNOWN;
    }

    static BindingStructuralType from(NormalizedNode data) {
        if (BindingStructuralType.isNotAddressable(data)) {
            return NOT_ADDRESSABLE;
        }
        if (data instanceof MapNode) {
            return INVISIBLE_LIST;
        }
        if (data instanceof ChoiceNode) {
            return INVISIBLE_CONTAINER;
        }
        if (BindingStructuralType.isVisibleContainer(data)) {
            return VISIBLE_CONTAINER;
        }
        return UNKNOWN;
    }

    public static BindingStructuralType recursiveFrom(DataTreeCandidateNode node) {
        BindingStructuralType type = BindingStructuralType.from(node);
        return switch (type.ordinal()) {
            case 1, 2 -> {
                Iterator var2_2 = node.childNodes().iterator();
                if (var2_2.hasNext()) {
                    DataTreeCandidateNode child = (DataTreeCandidateNode)var2_2.next();
                    BindingStructuralType childType = BindingStructuralType.recursiveFrom(child);
                    switch (childType.ordinal()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 1: 
                        case 2: {
                            yield NOT_ADDRESSABLE;
                        }
                        case 0: 
                        case 3: 
                        case 4: 
                    }
                    yield childType;
                }
                yield NOT_ADDRESSABLE;
            }
            default -> type;
        };
    }

    private static boolean isVisibleContainer(NormalizedNode data) {
        return data instanceof MapEntryNode || data instanceof ContainerNode;
    }

    private static boolean isNotAddressable(NormalizedNode normalizedNode) {
        return normalizedNode instanceof LeafNode || normalizedNode instanceof AnyxmlNode || normalizedNode instanceof AnydataNode || normalizedNode instanceof LeafSetNode || normalizedNode instanceof LeafSetEntryNode || normalizedNode instanceof UnkeyedListNode || normalizedNode instanceof UnkeyedListEntryNode;
    }
}

