/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcFutureAware;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.yangtools.binding.Action;
import org.opendaylight.yangtools.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class BindingOperationFluentFuture<O extends RpcOutput>
extends AbstractFuture<DOMRpcResult>
implements BindingRpcFutureAware {
    private final ListenableFuture<RpcResult<O>> userFuture;
    private final Class<? extends Action<?, ?, O>> action;
    private final YangInstanceIdentifier.NodeIdentifier identifier;
    private AdapterContext adapterContext;

    BindingOperationFluentFuture(ListenableFuture<RpcResult<O>> userFuture, Class<? extends Action<?, ?, O>> action, YangInstanceIdentifier.NodeIdentifier identifier, AdapterContext adapterContext) {
        this.userFuture = Objects.requireNonNull(userFuture);
        this.action = Objects.requireNonNull(action);
        this.identifier = Objects.requireNonNull(identifier);
        this.adapterContext = Objects.requireNonNull(adapterContext);
        userFuture.addListener(this::userFutureCompleted, MoreExecutors.directExecutor());
    }

    @Override
    public ListenableFuture<RpcResult<?>> getBindingFuture() {
        return this.userFuture;
    }

    private void userFutureCompleted() {
        DefaultDOMRpcResult domResult;
        try {
            RpcResult bindingResult = (RpcResult)Futures.getDone(this.userFuture);
            RpcOutput bindingValue = (RpcOutput)bindingResult.getResult();
            domResult = new DefaultDOMRpcResult(bindingValue == null ? null : this.adapterContext.currentSerializer().toLazyNormalizedNodeActionOutput(this.action, this.identifier, bindingValue), (Collection)bindingResult.getErrors());
        }
        catch (ExecutionException e) {
            this.adapterContext = null;
            this.setException(e.getCause());
            return;
        }
        catch (Error | RuntimeException e) {
            this.adapterContext = null;
            this.setException(e);
            return;
        }
        this.adapterContext = null;
        this.set(domResult);
    }
}

