/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.mdsal.binding.api.MountPoint;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterLoader;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class BindingMountPointAdapter
implements MountPoint {
    private final @NonNull DataObjectIdentifier<?> identifier;
    private final LoadingCache<Class<? extends BindingService>, Optional<BindingService>> services;

    BindingMountPointAdapter(AdapterContext codec, final DOMMountPoint domMountPoint) {
        this.identifier = codec.currentSerializer().fromYangInstanceIdentifier((YangInstanceIdentifier)domMountPoint.getIdentifier()).toIdentifier();
        this.services = CacheBuilder.newBuilder().build((CacheLoader)new BindingDOMAdapterLoader(this, codec){

            @Override
            protected DOMService<?, ?> getDelegate(Class<? extends DOMService<?, ?>> reqDeleg) {
                return reqDeleg.cast(domMountPoint.getService(reqDeleg).orElse(null));
            }
        });
    }

    public DataObjectIdentifier<?> getIdentifier() {
        return this.identifier;
    }

    public <T extends BindingService> Optional<T> getService(Class<T> service) {
        return ((Optional)this.services.getUnchecked(service)).map(service::cast);
    }
}

