/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDOMRpcResultFuture;
import org.opendaylight.mdsal.binding.dom.adapter.StaticConfiguration;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.binding.RpcInput;
import org.opendaylight.yangtools.binding.data.codec.api.BindingLazyContainerNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

final class BindingDOMRpcImplementationAdapter
implements DOMRpcImplementation {
    private final @NonNull AdapterContext adapterContext;
    private final @NonNull QName rpcName;
    private final @NonNull Rpc delegate;

    BindingDOMRpcImplementationAdapter(AdapterContext adapterContext, QName rpcName, Rpc<?, ?> delegate) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.rpcName = Objects.requireNonNull(rpcName);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public long invocationCost() {
        return 1L;
    }

    public ListenableFuture<DOMRpcResult> invokeRpc(DOMRpcIdentifier rpc, ContainerNode input) {
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        ListenableFuture future = this.delegate.invoke(this.deserialize(serializer, input));
        return LazyDOMRpcResultFuture.create((BindingNormalizedNodeSerializer)serializer, future);
    }

    private @NonNull RpcInput deserialize(@NonNull CurrentAdapterSerializer serializer, @NonNull ContainerNode input) {
        if (StaticConfiguration.ENABLE_CODEC_SHORTCUT && input instanceof BindingLazyContainerNode) {
            BindingLazyContainerNode lazy = (BindingLazyContainerNode)input;
            return (RpcInput)lazy.getDataObject();
        }
        QName inputName = input.name().getNodeType();
        if (!"input".equals(inputName.getLocalName()) || !this.rpcName.getModule().equals((Object)inputName.getModule())) {
            throw new IllegalArgumentException("Unexpected RPC " + String.valueOf(this.rpcName) + " input " + String.valueOf(input.prettyTree()));
        }
        return (RpcInput)Verify.verifyNotNull((Object)((RpcInput)serializer.fromNormalizedNodeRpcData(SchemaNodeIdentifier.Absolute.of((QName[])new QName[]{this.rpcName, inputName}), input)));
    }
}

