/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationListenerAdapter;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.concepts.Registration;

@VisibleForTesting
public class BindingDOMNotificationServiceAdapter
implements NotificationService {
    public static final BindingDOMAdapterBuilder.Factory<NotificationService> BUILDER_FACTORY = Builder::new;
    private final AdapterContext adapterContext;
    private final DOMNotificationService domNotifService;

    public BindingDOMNotificationServiceAdapter(AdapterContext adapterContext, DOMNotificationService domNotifService) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.domNotifService = domNotifService;
    }

    public <N extends Notification<N> & DataObject> Registration registerListener(Class<N> type, NotificationService.Listener<N> listener, Executor executor) {
        BindingDOMNotificationListenerAdapter<N> domListener = new BindingDOMNotificationListenerAdapter<N>(this.adapterContext, type, listener, executor);
        return this.domNotifService.registerNotificationListener(domListener, Set.of(domListener.schemaPath()));
    }

    public Registration registerCompositeListener(NotificationService.CompositeListener listener, Executor executor) {
        Executor exec = Objects.requireNonNull(executor);
        HashMap listeners = new HashMap();
        for (NotificationService.CompositeListener.Component constituent : listener.constituents()) {
            BindingDOMNotificationListenerAdapter domListener = new BindingDOMNotificationListenerAdapter(this.adapterContext, constituent, exec);
            listeners.put(domListener.schemaPath(), domListener);
        }
        return this.domNotifService.registerNotificationListeners(listeners);
    }

    private static class Builder
    extends BindingDOMAdapterBuilder<NotificationService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        protected NotificationService createInstance(ClassToInstanceMap<DOMService<?, ?>> delegates) {
            return new BindingDOMNotificationServiceAdapter(this.adapterContext(), (DOMNotificationService)delegates.getInstance(DOMNotificationService.class));
        }

        @Override
        public Set<? extends Class<? extends DOMService<?, ?>>> getRequiredDelegates() {
            return ImmutableSet.of(DOMNotificationService.class);
        }
    }
}

