/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.test.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataBrokerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMMountPointServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationPublishServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMNotificationServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcProviderServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.MockSchemaService;
import org.opendaylight.mdsal.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.broker.DOMMountPointServiceImpl;
import org.opendaylight.mdsal.dom.broker.DOMNotificationRouter;
import org.opendaylight.mdsal.dom.broker.DOMRpcRouter;
import org.opendaylight.mdsal.dom.broker.SerializedDOMDataBroker;
import org.opendaylight.mdsal.dom.spi.store.DOMStore;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStore;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;

@Beta
public class BindingTestContext
implements AutoCloseable {
    private final ListeningExecutorService executor;
    private final boolean startWithSchema;
    private DOMMountPointService biMountImpl;
    private ImmutableMap<LogicalDatastoreType, DOMStore> newDatastores;
    private DOMDataBroker newDOMDataBroker;
    private final MockSchemaService mockSchemaService = new MockSchemaService();
    private DataBroker dataBroker;
    private RpcConsumerRegistry baConsumerRpc;
    private BindingDOMRpcProviderServiceAdapter baProviderRpc;
    private DOMRpcRouter domRouter;
    private NotificationPublishService publishService;
    private NotificationService listenService;
    private DOMNotificationPublishService domPublishService;
    private DOMNotificationService domListenService;
    private Set<YangModuleInfo> schemaModuleInfos;

    public DOMDataBroker getDomAsyncDataBroker() {
        return this.newDOMDataBroker;
    }

    public AdapterContext getCodec() {
        return this.mockSchemaService;
    }

    protected BindingTestContext(ListeningExecutorService executor, boolean startWithSchema) {
        this.executor = executor;
        this.startWithSchema = startWithSchema;
    }

    public void startDomDataBroker() {
    }

    public void startNewDataBroker() {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"Executor needs to be set");
        Preconditions.checkState((this.newDOMDataBroker != null ? 1 : 0) != 0, (Object)"DOM Data Broker must be set");
        this.dataBroker = new BindingDOMDataBrokerAdapter((AdapterContext)this.mockSchemaService, this.newDOMDataBroker);
    }

    public void startNewDomDataBroker() {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"Executor needs to be set");
        InMemoryDOMDataStore operStore = new InMemoryDOMDataStore("OPER", (ExecutorService)MoreExecutors.newDirectExecutorService());
        InMemoryDOMDataStore configStore = new InMemoryDOMDataStore("CFG", (ExecutorService)MoreExecutors.newDirectExecutorService());
        this.newDatastores = ImmutableMap.builder().put((Object)LogicalDatastoreType.OPERATIONAL, (Object)operStore).put((Object)LogicalDatastoreType.CONFIGURATION, (Object)configStore).build();
        this.newDOMDataBroker = new SerializedDOMDataBroker(this.newDatastores, this.executor);
        this.mockSchemaService.registerSchemaContextListener((EffectiveModelContextListener)configStore);
        this.mockSchemaService.registerSchemaContextListener((EffectiveModelContextListener)operStore);
    }

    public void startBindingDataBroker() {
    }

    public void startBindingBroker() {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"Executor needs to be set");
        this.baConsumerRpc = new BindingDOMRpcServiceAdapter((AdapterContext)this.mockSchemaService, this.getDomRpcInvoker());
        this.baProviderRpc = new BindingDOMRpcProviderServiceAdapter((AdapterContext)this.mockSchemaService, this.getDomRpcRegistry());
        BindingDOMMountPointServiceAdapter mountService = new BindingDOMMountPointServiceAdapter((AdapterContext)this.mockSchemaService, this.biMountImpl);
    }

    public void startForwarding() {
    }

    public void startBindingToDomMappingService() {
    }

    private void updateYangSchema(Set<YangModuleInfo> moduleInfos) {
        this.mockSchemaService.changeSchema(BindingRuntimeHelpers.createRuntimeContext(moduleInfos));
    }

    public EffectiveModelContext getContext() {
        return this.mockSchemaService.getEffectiveModelContext();
    }

    public void start() {
        this.startNewDomDataBroker();
        this.startDomBroker();
        this.startDomMountPoint();
        this.startBindingToDomMappingService();
        this.startNewDataBroker();
        this.startBindingNotificationBroker();
        this.startBindingBroker();
        this.startForwarding();
        if (this.schemaModuleInfos != null) {
            this.updateYangSchema(this.schemaModuleInfos);
        } else if (this.startWithSchema) {
            this.loadYangSchemaFromClasspath();
        }
    }

    private void startDomMountPoint() {
        this.biMountImpl = new DOMMountPointServiceImpl();
    }

    private void startDomBroker() {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0);
        this.domRouter = new DOMRpcRouter();
        this.mockSchemaService.registerSchemaContextListener((EffectiveModelContextListener)this.domRouter);
    }

    public void startBindingNotificationBroker() {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0);
        DOMNotificationRouter router = DOMNotificationRouter.create((int)16);
        this.domPublishService = router;
        this.domListenService = router;
        this.publishService = new BindingDOMNotificationPublishServiceAdapter((AdapterContext)this.mockSchemaService, this.domPublishService);
        this.listenService = new BindingDOMNotificationServiceAdapter((AdapterContext)this.mockSchemaService, this.domListenService);
    }

    public void loadYangSchemaFromClasspath() {
        ImmutableSet moduleInfos = BindingReflections.loadModuleInfos();
        this.updateYangSchema((Set<YangModuleInfo>)moduleInfos);
    }

    public DOMRpcProviderService getDomRpcRegistry() {
        return this.domRouter.getRpcProviderService();
    }

    public DOMRpcService getDomRpcInvoker() {
        return this.domRouter.getRpcService();
    }

    public RpcProviderService getBindingRpcProviderRegistry() {
        return this.baProviderRpc;
    }

    public RpcConsumerRegistry getBindingRpcConsumerRegistry() {
        return this.baConsumerRpc;
    }

    @Override
    public void close() throws Exception {
    }

    public DOMMountPointService getDomMountProviderService() {
        return this.biMountImpl;
    }

    public DataBroker getDataBroker() {
        return this.dataBroker;
    }

    public void setSchemaModuleInfos(Set<YangModuleInfo> moduleInfos) {
        this.schemaModuleInfos = moduleInfos;
    }
}

