/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.test;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTestCustomizer;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractSchemaAwareTest;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;

public abstract class AbstractBaseDataBrokerTest
extends AbstractSchemaAwareTest {
    private static final int ASSERT_COMMIT_DEFAULT_TIMEOUT = 5000;
    private AbstractDataBrokerTestCustomizer testCustomizer;
    private DataBroker dataBroker;
    private DOMDataBroker domBroker;

    protected abstract AbstractDataBrokerTestCustomizer createDataBrokerTestCustomizer();

    public AbstractDataBrokerTestCustomizer getDataBrokerTestCustomizer() {
        if (this.testCustomizer == null) {
            throw new IllegalStateException("testCustomizer not yet set by call to createDataBrokerTestCustomizer()");
        }
        return this.testCustomizer;
    }

    @Override
    protected void setupWithRuntimeContext(BindingRuntimeContext runtimeContext) {
        this.testCustomizer = this.createDataBrokerTestCustomizer();
        this.dataBroker = this.testCustomizer.createDataBroker();
        this.domBroker = this.testCustomizer.getDOMDataBroker();
        this.testCustomizer.updateSchema(runtimeContext);
        super.setupWithRuntimeContext(runtimeContext);
    }

    public DataBroker getDataBroker() {
        return this.dataBroker;
    }

    public DOMDataBroker getDomBroker() {
        return this.domBroker;
    }

    protected static final void assertCommit(ListenableFuture<?> commit) {
        AbstractBaseDataBrokerTest.assertCommit(commit, 5000L);
    }

    protected static final void assertCommit(ListenableFuture<?> commit, long timeoutInMS) {
        try {
            commit.get(timeoutInMS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }
}

