/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.osgi;

import com.google.common.collect.ImmutableSet;
import java.util.Dictionary;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.AdaptingTracker;
import org.osgi.framework.ServiceReference;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class AdaptingTrackerTest {
    @Mock
    private ServiceReference<?> ref;
    @Mock
    private BindingService service;

    @Test
    public void testReferenceProperties() {
        ((ServiceReference)Mockito.doReturn((Object)new String[]{"foo", "bar", "odl.mdsal.binding.adapter.xyzzy"}).when(this.ref)).getPropertyKeys();
        ((ServiceReference)Mockito.doReturn((Object)"foo").when(this.ref)).getProperty("foo");
        ((ServiceReference)Mockito.doReturn((Object)"bar").when(this.ref)).getProperty("bar");
        Dictionary dict = AdaptingTracker.referenceProperties(this.ref, (BindingService)this.service);
        Assert.assertEquals((long)3L, (long)dict.size());
        Assert.assertFalse((boolean)dict.isEmpty());
        Assert.assertEquals(Set.of("foo", "bar", "org.opendaylight.mdsal.binding.dom.adapter.osgi.AbstractAdaptedService.DELEGATE"), (Object)ImmutableSet.copyOf(dict.keys().asIterator()));
        Assert.assertEquals(Set.of("foo", "bar", this.service), (Object)ImmutableSet.copyOf(dict.elements().asIterator()));
        Assert.assertNull(dict.get("xyzzy"));
        Assert.assertEquals((Object)"foo", dict.get("foo"));
        Assert.assertEquals((Object)"bar", dict.get("bar"));
        Assert.assertSame((Object)this.service, dict.get("org.opendaylight.mdsal.binding.dom.adapter.osgi.AbstractAdaptedService.DELEGATE"));
    }
}

