/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.invoke;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.WrongMethodTypeException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.NotificationListenerInvoker;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.common.QName;

public class NotificationListenerInvokerTest {
    @Test
    public void fromTest() throws Exception {
        Assert.assertNotNull((Object)NotificationListenerInvoker.from(TestInterface.class));
    }

    @Test
    public void fromWithExceptionTest() {
        Throwable cause = ((UncheckedExecutionException)Assert.assertThrows(UncheckedExecutionException.class, () -> NotificationListenerInvoker.from(TestPrivateInterface.class))).getCause();
        MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)cause.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalAccessException.class));
    }

    @Test
    public void invokeNotification() {
        NotificationListener notificationListener = (NotificationListener)Mockito.mock(NotificationListener.class);
        MethodHandle methodHandle = (MethodHandle)Mockito.mock(MethodHandle.class);
        NotificationListenerInvoker notificationListenerInvoker = new NotificationListenerInvoker(ImmutableMap.of((Object)QName.create((String)"test", (String)"test"), (Object)methodHandle));
        WrongMethodTypeException ex = (WrongMethodTypeException)Assert.assertThrows(WrongMethodTypeException.class, () -> notificationListenerInvoker.invokeNotification(notificationListener, QName.create((String)"test", (String)"test"), null));
        Assert.assertEquals((Object)"expected null but found (NotificationListener,DataContainer)void", (Object)ex.getMessage());
    }

    public static interface TestInterface
    extends NotificationListener,
    Augmentation {
        public static final QName QNAME = QName.create((String)"test", (String)"test");

        public void onTestNotificationInterface(TestNotificationInterface var1);
    }

    private static interface TestPrivateInterface
    extends NotificationListener,
    Augmentation {
        public static final QName QNAME = QName.create((String)"test", (String)"test");

        public void onTestNotificationInterface(TestNotificationInterface var1);
    }

    public static interface TestNotificationInterface
    extends DataObject,
    Notification<TestNotificationInterface> {
        public static final QName QNAME = QName.create((String)"test", (String)"test");
    }
}

