/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.RpcServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingBrokerTestFactory;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingTestContext;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.OpendaylightTestRpcServiceService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.RockTheHouseInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.RockTheHouseInputBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;

@ExtendWith(value={MockitoExtension.class})
public class Mdsal739Test {
    private ListeningExecutorService executorService;
    private AdapterContext adapterContext;

    @BeforeEach
    public void before() {
        this.executorService = MoreExecutors.newDirectExecutorService();
        BindingBrokerTestFactory bindingBrokerTestFactory = new BindingBrokerTestFactory();
        bindingBrokerTestFactory.setExecutor((ExecutorService)this.executorService);
        BindingTestContext bindingTestContext = bindingBrokerTestFactory.getTestContext();
        bindingTestContext.start();
        this.adapterContext = bindingTestContext.getCodec();
    }

    @AfterEach
    public void after() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testRpcInputName() {
        DOMRpcService rpcService = (DOMRpcService)Mockito.mock(DOMRpcService.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ContainerNode.class);
        ((DOMRpcService)Mockito.doReturn((Object)Futures.immediateFailedFuture((Throwable)new Throwable())).when((Object)rpcService)).invokeRpc((QName)ArgumentMatchers.any(), (ContainerNode)captor.capture());
        OpendaylightTestRpcServiceService adapter = (OpendaylightTestRpcServiceService)new RpcServiceAdapter(OpendaylightTestRpcServiceService.class, this.adapterContext, rpcService).facade();
        ListenableFuture result = adapter.rockTheHouse(new RockTheHouseInputBuilder().setZipCode("12345").build());
        Assertions.assertThrows(ExecutionException.class, () -> Futures.getDone((Future)result));
        ContainerNode input = (ContainerNode)captor.getValue();
        MatcherAssert.assertThat((Object)input, (Matcher)CoreMatchers.instanceOf(ContainerNode.class));
        Assertions.assertSame((Object)YangInstanceIdentifier.NodeIdentifier.create((QName)RockTheHouseInput.QNAME), (Object)input.getIdentifier());
        Collection body = input.body();
        Assertions.assertEquals((int)1, (int)body.size());
        Assertions.assertEquals((Object)ImmutableNodes.leafNode((QName)QName.create((QName)RockTheHouseInput.QNAME, (String)"zip-code"), (Object)"12345"), body.iterator().next());
    }
}

