/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTest;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test._2.rev160111.MyDerivedImportedIdentity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.BigIntContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.BigIntContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.BigUintContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.BigUintContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.BinaryContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.BinaryContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.BitsContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.BitsContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.BooleanContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.BooleanContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.DecimalContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.DecimalContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.EnumContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.EnumContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.IdentityrefContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.IdentityrefContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.MyDerivedIdentity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.MyDerivedIdentity2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.NormalIntContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.NormalIntContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.NormalUintContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.NormalUintContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.SmallIntContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.SmallIntContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.SmallUintContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.SmallUintContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.StringContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.StringContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.TinyIntContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.TinyIntContainerBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.TinyUintContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev.TinyUintContainerBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class LeafDefaultValueTest
extends AbstractDataBrokerTest {
    private static final InstanceIdentifier<TinyIntContainer> TINY_INT_NODE_PATH = InstanceIdentifier.create(TinyIntContainer.class);
    private static final InstanceIdentifier<SmallIntContainer> SMALL_INT_NODE_PATH = InstanceIdentifier.create(SmallIntContainer.class);
    private static final InstanceIdentifier<NormalIntContainer> NORMAL_INT_NODE_PATH = InstanceIdentifier.create(NormalIntContainer.class);
    private static final InstanceIdentifier<BigIntContainer> BIG_INT_NODE_PATH = InstanceIdentifier.create(BigIntContainer.class);
    private static final InstanceIdentifier<TinyUintContainer> TINY_UINT_NODE_PATH = InstanceIdentifier.create(TinyUintContainer.class);
    private static final InstanceIdentifier<SmallUintContainer> SMALL_UINT_NODE_PATH = InstanceIdentifier.create(SmallUintContainer.class);
    private static final InstanceIdentifier<NormalUintContainer> NORMAL_UINT_NODE_PATH = InstanceIdentifier.create(NormalUintContainer.class);
    private static final InstanceIdentifier<BigUintContainer> BIG_UINT_NODE_PATH = InstanceIdentifier.create(BigUintContainer.class);
    private static final InstanceIdentifier<DecimalContainer> DECIMAL_NODE_PATH = InstanceIdentifier.create(DecimalContainer.class);
    private static final InstanceIdentifier<StringContainer> STRING_NODE_PATH = InstanceIdentifier.create(StringContainer.class);
    private static final InstanceIdentifier<BooleanContainer> BOOLEAN_NODE_PATH = InstanceIdentifier.create(BooleanContainer.class);
    private static final InstanceIdentifier<EnumContainer> ENUM_NODE_PATH = InstanceIdentifier.create(EnumContainer.class);
    private static final InstanceIdentifier<BitsContainer> BITS_NODE_PATH = InstanceIdentifier.create(BitsContainer.class);
    private static final InstanceIdentifier<BinaryContainer> BINARY_NODE_PATH = InstanceIdentifier.create(BinaryContainer.class);
    private static final InstanceIdentifier<IdentityrefContainer> IDENTITYREF_NODE_PATH = InstanceIdentifier.create(IdentityrefContainer.class);

    @Test
    public void testTinyIntDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, TINY_INT_NODE_PATH, (DataObject)new TinyIntContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional tinyIntContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, TINY_INT_NODE_PATH).get();
        Assert.assertTrue((boolean)tinyIntContainerNode.isPresent());
        TinyIntContainer tinyIntContainer = (TinyIntContainer)tinyIntContainerNode.get();
        Assert.assertEquals((long)-18L, (long)tinyIntContainer.getTinyIntLeaf().getValue().byteValue());
        Assert.assertEquals((long)-18L, (long)tinyIntContainer.getTinyIntLeaf2().getValue().byteValue());
        Assert.assertEquals((long)-15L, (long)tinyIntContainer.getTinyIntLeaf3().getValue().byteValue());
        Assert.assertEquals((long)-18L, (long)tinyIntContainer.getTinyIntLeaf4().getValue().byteValue());
        Assert.assertEquals((long)-120L, (long)tinyIntContainer.getTinyIntLeaf5().byteValue());
        Assert.assertEquals(null, (Object)tinyIntContainer.getTinyIntLeaf6());
    }

    @Test
    public void testSmallIntDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, SMALL_INT_NODE_PATH, (DataObject)new SmallIntContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional smallIntContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, SMALL_INT_NODE_PATH).get();
        Assert.assertTrue((boolean)smallIntContainerNode.isPresent());
        SmallIntContainer smallIntContainer = (SmallIntContainer)smallIntContainerNode.get();
        Assert.assertEquals((long)-20000L, (long)smallIntContainer.getSmallIntLeaf().getValue().shortValue());
        Assert.assertEquals((long)-20000L, (long)smallIntContainer.getSmallIntLeaf2().getValue().shortValue());
        Assert.assertEquals((long)-15000L, (long)smallIntContainer.getSmallIntLeaf3().getValue().shortValue());
        Assert.assertEquals((long)-20000L, (long)smallIntContainer.getSmallIntLeaf4().getValue().shortValue());
        Assert.assertEquals((long)-5000L, (long)smallIntContainer.getSmallIntLeaf5().shortValue());
        Assert.assertEquals(null, (Object)smallIntContainer.getSmallIntLeaf6());
    }

    @Test
    public void testNormalIntDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, NORMAL_INT_NODE_PATH, (DataObject)new NormalIntContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional normalIntContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, NORMAL_INT_NODE_PATH).get();
        Assert.assertTrue((boolean)normalIntContainerNode.isPresent());
        NormalIntContainer normalIntContainer = (NormalIntContainer)normalIntContainerNode.get();
        Assert.assertEquals((long)-200000L, (long)normalIntContainer.getNormalIntLeaf().getValue().intValue());
        Assert.assertEquals((long)-200000L, (long)normalIntContainer.getNormalIntLeaf2().getValue().intValue());
        Assert.assertEquals((long)-130000L, (long)normalIntContainer.getNormalIntLeaf3().getValue().intValue());
        Assert.assertEquals((long)-200000L, (long)normalIntContainer.getNormalIntLeaf4().getValue().intValue());
        Assert.assertEquals((long)-95000L, (long)normalIntContainer.getNormalIntLeaf5().intValue());
        Assert.assertEquals(null, (Object)normalIntContainer.getNormalIntLeaf6());
    }

    @Test
    public void testBigIntDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, BIG_INT_NODE_PATH, (DataObject)new BigIntContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional bigIntContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, BIG_INT_NODE_PATH).get();
        Assert.assertTrue((boolean)bigIntContainerNode.isPresent());
        BigIntContainer bigIntContainer = (BigIntContainer)bigIntContainerNode.get();
        Assert.assertEquals((long)-3300000000L, (long)bigIntContainer.getBigIntLeaf().getValue());
        Assert.assertEquals((long)-3300000000L, (long)bigIntContainer.getBigIntLeaf2().getValue());
        Assert.assertEquals((long)-2800000000L, (long)bigIntContainer.getBigIntLeaf3().getValue());
        Assert.assertEquals((long)-3300000000L, (long)bigIntContainer.getBigIntLeaf4().getValue());
        Assert.assertEquals((long)-2500000000L, (long)bigIntContainer.getBigIntLeaf5());
        Assert.assertEquals(null, (Object)bigIntContainer.getBigIntLeaf6());
    }

    @Test
    public void testTinyUintDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, TINY_UINT_NODE_PATH, (DataObject)new TinyUintContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional tinyUintContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, TINY_UINT_NODE_PATH).get();
        Assert.assertTrue((boolean)tinyUintContainerNode.isPresent());
        TinyUintContainer tinyUintContainer = (TinyUintContainer)tinyUintContainerNode.get();
        Assert.assertEquals((long)150L, (long)tinyUintContainer.getTinyUintLeaf().getValue().shortValue());
        Assert.assertEquals((long)150L, (long)tinyUintContainer.getTinyUintLeaf2().getValue().shortValue());
        Assert.assertEquals((long)170L, (long)tinyUintContainer.getTinyUintLeaf3().getValue().shortValue());
        Assert.assertEquals((long)150L, (long)tinyUintContainer.getTinyUintLeaf4().getValue().shortValue());
        Assert.assertEquals((long)155L, (long)tinyUintContainer.getTinyUintLeaf5().shortValue());
        Assert.assertEquals(null, (Object)tinyUintContainer.getTinyUintLeaf6());
    }

    @Test
    public void testSmallUintDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, SMALL_UINT_NODE_PATH, (DataObject)new SmallUintContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional smallUintContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, SMALL_UINT_NODE_PATH).get();
        Assert.assertTrue((boolean)smallUintContainerNode.isPresent());
        SmallUintContainer smallUintContainer = (SmallUintContainer)smallUintContainerNode.get();
        Assert.assertEquals((long)35000L, (long)smallUintContainer.getSmallUintLeaf().getValue().intValue());
        Assert.assertEquals((long)35000L, (long)smallUintContainer.getSmallUintLeaf2().getValue().intValue());
        Assert.assertEquals((long)45000L, (long)smallUintContainer.getSmallUintLeaf3().getValue().intValue());
        Assert.assertEquals((long)35000L, (long)smallUintContainer.getSmallUintLeaf4().getValue().intValue());
        Assert.assertEquals((long)62000L, (long)smallUintContainer.getSmallUintLeaf5().intValue());
        Assert.assertEquals(null, (Object)smallUintContainer.getSmallUintLeaf6());
    }

    @Test
    public void testNormalUintDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, NORMAL_UINT_NODE_PATH, (DataObject)new NormalUintContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional normalUintContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, NORMAL_UINT_NODE_PATH).get();
        Assert.assertTrue((boolean)normalUintContainerNode.isPresent());
        NormalUintContainer normalUintContainer = (NormalUintContainer)normalUintContainerNode.get();
        Assert.assertEquals((long)100000L, (long)normalUintContainer.getNormalUintLeaf().getValue().longValue());
        Assert.assertEquals((long)100000L, (long)normalUintContainer.getNormalUintLeaf2().getValue().longValue());
        Assert.assertEquals((long)250000L, (long)normalUintContainer.getNormalUintLeaf3().getValue().longValue());
        Assert.assertEquals((long)100000L, (long)normalUintContainer.getNormalUintLeaf4().getValue().longValue());
        Assert.assertEquals((long)150000L, (long)normalUintContainer.getNormalUintLeaf5().longValue());
        Assert.assertEquals(null, (Object)normalUintContainer.getNormalUintLeaf6());
    }

    @Test
    public void testBigUintDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, BIG_UINT_NODE_PATH, (DataObject)new BigUintContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional bigUintContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, BIG_UINT_NODE_PATH).get();
        Assert.assertTrue((boolean)bigUintContainerNode.isPresent());
        BigUintContainer bigUintContainer = (BigUintContainer)bigUintContainerNode.get();
        Assert.assertEquals((long)5000000000L, (long)bigUintContainer.getBigUintLeaf().getValue().longValue());
        Assert.assertEquals((long)5000000000L, (long)bigUintContainer.getBigUintLeaf2().getValue().longValue());
        Assert.assertEquals((long)5800000000L, (long)bigUintContainer.getBigUintLeaf3().getValue().longValue());
        Assert.assertEquals((long)5000000000L, (long)bigUintContainer.getBigUintLeaf4().getValue().longValue());
        Assert.assertEquals((long)6500000000L, (long)bigUintContainer.getBigUintLeaf5().longValue());
        Assert.assertEquals(null, (Object)bigUintContainer.getBigUintLeaf6());
    }

    @Test
    public void testDecimalDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, DECIMAL_NODE_PATH, (DataObject)new DecimalContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional decimalContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, DECIMAL_NODE_PATH).get();
        Assert.assertTrue((boolean)decimalContainerNode.isPresent());
        DecimalContainer decimalCont = (DecimalContainer)decimalContainerNode.get();
        Assert.assertEquals((double)66.66, (double)decimalCont.getDecimalLeaf().getValue().doubleValue(), (double)0.001);
        Assert.assertEquals((double)66.66, (double)decimalCont.getDecimalLeaf2().getValue().doubleValue(), (double)0.001);
        Assert.assertEquals((double)99.99, (double)decimalCont.getDecimalLeaf3().getValue().doubleValue(), (double)0.001);
        Assert.assertEquals((double)66.66, (double)decimalCont.getDecimalLeaf4().getValue().doubleValue(), (double)0.001);
        Assert.assertEquals((double)120.55, (double)decimalCont.getDecimalLeaf5().doubleValue(), (double)0.001);
        Assert.assertEquals(null, (Object)decimalCont.getDecimalLeaf6());
    }

    @Test
    public void testStringDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, STRING_NODE_PATH, (DataObject)new StringContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional stringContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, STRING_NODE_PATH).get();
        Assert.assertTrue((boolean)stringContainerNode.isPresent());
        StringContainer stringCont = (StringContainer)stringContainerNode.get();
        Assert.assertEquals((Object)"unspecified string", (Object)stringCont.getStringLeaf().getValue());
        Assert.assertEquals((Object)"unspecified string", (Object)stringCont.getStringLeaf2().getValue());
        Assert.assertEquals((Object)"unknown", (Object)stringCont.getStringLeaf3().getValue());
        Assert.assertEquals((Object)"unspecified string", (Object)stringCont.getStringLeaf4().getValue());
        Assert.assertEquals((Object)"whatever", (Object)stringCont.getStringLeaf5());
        Assert.assertNull((Object)stringCont.getStringLeaf6());
    }

    @Test
    public void testBooleanDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, BOOLEAN_NODE_PATH, (DataObject)new BooleanContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional booleanContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, BOOLEAN_NODE_PATH).get();
        Assert.assertTrue((boolean)booleanContainerNode.isPresent());
        BooleanContainer boolCont = (BooleanContainer)booleanContainerNode.get();
        Assert.assertTrue((boolean)boolCont.getBooleanLeaf());
        Assert.assertNull((Object)boolCont.getBooleanLeaf2());
    }

    @Test
    public void testEnumerationDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, ENUM_NODE_PATH, (DataObject)new EnumContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional enumContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, ENUM_NODE_PATH).get();
        Assert.assertTrue((boolean)enumContainerNode.isPresent());
        EnumContainer enumCont = (EnumContainer)enumContainerNode.get();
        Assert.assertEquals((Object)"Second", (Object)enumCont.getEnumLeaf().name());
        Assert.assertEquals((long)2L, (long)enumCont.getEnumLeaf().getIntValue());
    }

    @Test
    public void testBitsDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, BITS_NODE_PATH, (DataObject)new BitsContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional bitsContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, BITS_NODE_PATH).get();
        Assert.assertTrue((boolean)bitsContainerNode.isPresent());
        BitsContainer bitsCont = (BitsContainer)bitsContainerNode.get();
        Assert.assertFalse((boolean)bitsCont.getBitsLeaf().getBitZero());
        Assert.assertTrue((boolean)bitsCont.getBitsLeaf().getBitOne());
        Assert.assertFalse((boolean)bitsCont.getBitsLeaf().getBitTwo());
        Assert.assertNull((Object)bitsCont.getBitsLeaf2());
    }

    @Test
    public void testBinaryDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, BINARY_NODE_PATH, (DataObject)new BinaryContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional binaryContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, BINARY_NODE_PATH).get();
        Assert.assertTrue((boolean)binaryContainerNode.isPresent());
        BinaryContainer binCont = (BinaryContainer)binaryContainerNode.get();
        byte[] expectedBytes = new byte[]{104, 101, 108, 108, 111};
        byte[] actualBytes = binCont.getBinaryLeaf();
        Assert.assertTrue((boolean)Arrays.equals(expectedBytes, actualBytes));
    }

    @Test
    public void testIdentityrefDefaultValue() throws ExecutionException, InterruptedException {
        WriteTransaction writeTx = this.getDataBroker().newWriteOnlyTransaction();
        writeTx.put(LogicalDatastoreType.OPERATIONAL, IDENTITYREF_NODE_PATH, (DataObject)new IdentityrefContainerBuilder().build());
        writeTx.commit().get();
        ReadTransaction readTx = this.getDataBroker().newReadOnlyTransaction();
        Optional identityrefContainerNode = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, IDENTITYREF_NODE_PATH).get();
        Assert.assertTrue((boolean)identityrefContainerNode.isPresent());
        IdentityrefContainer idrefCont = (IdentityrefContainer)identityrefContainerNode.get();
        Assert.assertNull((Object)idrefCont.getIdentityrefLeaf());
        Assert.assertSame((Object)MyDerivedIdentity.VALUE, (Object)idrefCont.getIdentityrefLeaf2());
        Assert.assertSame((Object)MyDerivedIdentity.VALUE, (Object)idrefCont.getIdentityrefLeaf3());
        Assert.assertSame((Object)MyDerivedIdentity2.VALUE, (Object)idrefCont.getIdentityrefLeaf4());
        Assert.assertSame((Object)MyDerivedImportedIdentity.VALUE, (Object)idrefCont.getIdentityrefLeaf5());
        Assert.assertSame((Object)MyDerivedIdentity.VALUE, (Object)idrefCont.getIdentityrefLeaf6());
        Assert.assertNull((Object)idrefCont.getIdentityrefLeaf7());
    }
}

