/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDOMRpcResultFuture;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.RpcResult;

public class LazyDOMRpcResultFutureTest {
    private LazyDOMRpcResultFuture lazyDOMRpcResultFuture;
    private final BindingNormalizedNodeSerializer codec = (BindingNormalizedNodeSerializer)Mockito.mock(BindingNormalizedNodeSerializer.class);
    private final ListenableFuture<RpcResult<?>> future = (ListenableFuture)Mockito.mock(ListenableFuture.class);
    private final RpcResult<?> domRpcResult = (RpcResult)Mockito.mock(RpcResult.class);

    @Before
    public void setUp() throws Exception {
        this.lazyDOMRpcResultFuture = LazyDOMRpcResultFuture.create((BindingNormalizedNodeSerializer)this.codec, this.future);
        Mockito.reset((Object[])new ListenableFuture[]{this.future});
        ((ListenableFuture)Mockito.doReturn((Object)true).when(this.future)).cancel(ArgumentMatchers.anyBoolean());
        ((ListenableFuture)Mockito.doNothing().when(this.future)).addListener((Runnable)ArgumentMatchers.any(), (Executor)ArgumentMatchers.any());
        ((RpcResult)Mockito.doReturn((Object)true).when(this.domRpcResult)).isSuccessful();
        ((ListenableFuture)Mockito.doReturn((Object)true).when(this.future)).isCancelled();
        ((ListenableFuture)Mockito.doReturn((Object)true).when(this.future)).isDone();
        ((RpcResult)Mockito.doReturn((Object)Mockito.mock(RpcOutput.class)).when(this.domRpcResult)).getResult();
        ((ListenableFuture)Mockito.doReturn(this.domRpcResult).when(this.future)).get();
        ((ListenableFuture)Mockito.doReturn(this.domRpcResult).when(this.future)).get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void basicTest() throws Exception {
        Assert.assertNotNull((Object)this.lazyDOMRpcResultFuture);
        Assert.assertEquals(this.future, (Object)this.lazyDOMRpcResultFuture.getBindingFuture());
        this.lazyDOMRpcResultFuture.cancel(true);
        ((ListenableFuture)Mockito.verify(this.future)).cancel(ArgumentMatchers.anyBoolean());
        this.lazyDOMRpcResultFuture.addListener((Runnable)ArgumentMatchers.any(), (Executor)ArgumentMatchers.any());
        ((ListenableFuture)Mockito.verify(this.future)).addListener((Runnable)ArgumentMatchers.any(), (Executor)ArgumentMatchers.any());
        Assert.assertTrue((this.lazyDOMRpcResultFuture.isCancelled() && this.lazyDOMRpcResultFuture.isDone() ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.lazyDOMRpcResultFuture.get(), (Object)this.lazyDOMRpcResultFuture.get(1L, TimeUnit.SECONDS));
        Field result = LazyDOMRpcResultFuture.class.getDeclaredField("result");
        result.setAccessible(true);
        result.set(this.lazyDOMRpcResultFuture, null);
        Assert.assertEquals((Object)this.lazyDOMRpcResultFuture.get(1L, TimeUnit.SECONDS), (Object)this.lazyDOMRpcResultFuture.get());
        result.set(this.lazyDOMRpcResultFuture, null);
        ((RpcResult)Mockito.doReturn((Object)new Object()).when(this.domRpcResult)).getResult();
        Assert.assertNotNull((Object)this.lazyDOMRpcResultFuture.get());
        result.set(this.lazyDOMRpcResultFuture, null);
        ((RpcResult)Mockito.doReturn((Object)false).when(this.domRpcResult)).isSuccessful();
        ((RpcResult)Mockito.doReturn((Object)ImmutableList.of()).when(this.domRpcResult)).getErrors();
        Assert.assertNotNull((Object)this.lazyDOMRpcResultFuture.get());
    }

    @Test(expected=InterruptedException.class)
    public void checkedGetWithException() throws Throwable {
        ((ListenableFuture)Mockito.doThrow(InterruptedException.class).when(this.future)).get();
        try {
            this.lazyDOMRpcResultFuture.get();
        }
        catch (RuntimeException e) {
            throw e.getCause();
        }
    }

    @Test(expected=InterruptedException.class)
    public void checkedGetWithException2() throws Throwable {
        ((ListenableFuture)Mockito.doThrow(InterruptedException.class).when(this.future)).get(1L, TimeUnit.SECONDS);
        try {
            this.lazyDOMRpcResultFuture.get(1L, TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            throw e.getCause();
        }
    }
}

