/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataBrokerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTest;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.binding.test.model.util.ListsBindingUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.TreeComplexUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.complex.from.grouping.ListViaUsesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.TwoLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

public class DataTreeChangeListenerTest
extends AbstractDataBrokerTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    private static final InstanceIdentifier.PathArgument TOP_ARGUMENT = (InstanceIdentifier.PathArgument)TOP_PATH.getPathArguments().iterator().next();
    private static final InstanceIdentifier<TopLevelList> FOO_PATH = ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY);
    private static final InstanceIdentifier.PathArgument FOO_ARGUMENT = (InstanceIdentifier.PathArgument)Iterables.getLast((Iterable)FOO_PATH.getPathArguments());
    private static final TopLevelList FOO_DATA = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, (TreeComplexUsesAugment)ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{ListsBindingUtils.USES_ONE_KEY}));
    private static final InstanceIdentifier<TopLevelList> BAR_PATH = ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
    private static final InstanceIdentifier.PathArgument BAR_ARGUMENT = (InstanceIdentifier.PathArgument)Iterables.getLast((Iterable)BAR_PATH.getPathArguments());
    private static final TopLevelList BAR_DATA = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
    private static final DataTreeIdentifier<Top> TOP_IDENTIFIER = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, TOP_PATH);
    private static final Top TOP_INITIAL_DATA = ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{FOO_DATA});
    private BindingDOMDataBrokerAdapter dataBrokerImpl;

    @Override
    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return ImmutableSet.of((Object)BindingReflections.getModuleInfo(TwoLevelList.class), (Object)BindingReflections.getModuleInfo(TreeComplexUsesAugment.class));
    }

    @Override
    protected void setupWithDataBroker(DataBroker dataBroker) {
        this.dataBrokerImpl = (BindingDOMDataBrokerAdapter)dataBroker;
    }

    @Test
    public void testTopLevelListener() throws Exception {
        EventCapturingListener<Top> listener = new EventCapturingListener<Top>();
        this.dataBrokerImpl.registerDataTreeChangeListener(TOP_IDENTIFIER, listener);
        this.createAndVerifyTop(listener);
        this.putTx(BAR_PATH, BAR_DATA).commit().get();
        DataObjectModification afterBarPutEvent = ((DataTreeModification)Iterables.getOnlyElement(listener.nextEvent())).getRootNode();
        DataTreeChangeListenerTest.verifyModification((DataObjectModification<? extends DataObject>)afterBarPutEvent, TOP_ARGUMENT, DataObjectModification.ModificationType.SUBTREE_MODIFIED);
        DataObjectModification barPutMod = afterBarPutEvent.getModifiedChildListItem(TopLevelList.class, (Identifier)ListsBindingUtils.TOP_BAR_KEY);
        Assert.assertNotNull((Object)barPutMod);
        DataTreeChangeListenerTest.verifyModification((DataObjectModification<? extends DataObject>)barPutMod, BAR_ARGUMENT, DataObjectModification.ModificationType.WRITE);
        this.deleteTx(BAR_PATH).commit().get();
        DataObjectModification afterBarDeleteEvent = ((DataTreeModification)Iterables.getOnlyElement(listener.nextEvent())).getRootNode();
        DataTreeChangeListenerTest.verifyModification((DataObjectModification<? extends DataObject>)afterBarDeleteEvent, TOP_ARGUMENT, DataObjectModification.ModificationType.SUBTREE_MODIFIED);
        DataObjectModification barDeleteMod = afterBarDeleteEvent.getModifiedChildListItem(TopLevelList.class, (Identifier)ListsBindingUtils.TOP_BAR_KEY);
        DataTreeChangeListenerTest.verifyModification((DataObjectModification<? extends DataObject>)barDeleteMod, BAR_ARGUMENT, DataObjectModification.ModificationType.DELETE);
        this.dataBrokerImpl.registerDataTreeChangeListener(TOP_IDENTIFIER, listener).close();
    }

    @Test
    public void testWildcardedListListener() throws Exception {
        EventCapturingListener listener = new EventCapturingListener();
        DataTreeIdentifier wildcard = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)TOP_PATH.child(TopLevelList.class));
        this.dataBrokerImpl.registerDataTreeChangeListener(wildcard, listener);
        this.putTx(TOP_PATH, TOP_INITIAL_DATA).commit().get();
        DataTreeModification fooWriteEvent = (DataTreeModification)Iterables.getOnlyElement(listener.nextEvent());
        Assert.assertEquals(FOO_PATH, (Object)fooWriteEvent.getRootPath().getRootIdentifier());
        DataTreeChangeListenerTest.verifyModification((DataObjectModification<? extends DataObject>)fooWriteEvent.getRootNode(), FOO_ARGUMENT, DataObjectModification.ModificationType.WRITE);
        this.putTx(BAR_PATH, BAR_DATA).commit().get();
        DataTreeModification barWriteEvent = (DataTreeModification)Iterables.getOnlyElement(listener.nextEvent());
        Assert.assertEquals(BAR_PATH, (Object)barWriteEvent.getRootPath().getRootIdentifier());
        DataTreeChangeListenerTest.verifyModification((DataObjectModification<? extends DataObject>)barWriteEvent.getRootNode(), BAR_ARGUMENT, DataObjectModification.ModificationType.WRITE);
        this.deleteTx(BAR_PATH).commit().get();
        DataTreeModification barDeleteEvent = (DataTreeModification)Iterables.getOnlyElement(listener.nextEvent());
        Assert.assertEquals(BAR_PATH, (Object)barDeleteEvent.getRootPath().getRootIdentifier());
        DataTreeChangeListenerTest.verifyModification((DataObjectModification<? extends DataObject>)barDeleteEvent.getRootNode(), BAR_ARGUMENT, DataObjectModification.ModificationType.DELETE);
    }

    @Test
    public void testWildcardedListListenerWithPreexistingData() throws Exception {
        this.putTx(TOP_PATH, TOP_INITIAL_DATA).commit().get();
        EventCapturingListener listener = new EventCapturingListener();
        DataTreeIdentifier wildcard = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)TOP_PATH.child(TopLevelList.class));
        this.dataBrokerImpl.registerDataTreeChangeListener(wildcard, listener);
        DataTreeModification fooWriteEvent = (DataTreeModification)Iterables.getOnlyElement(listener.nextEvent());
        Assert.assertEquals(FOO_PATH, (Object)fooWriteEvent.getRootPath().getRootIdentifier());
        DataTreeChangeListenerTest.verifyModification((DataObjectModification<? extends DataObject>)fooWriteEvent.getRootNode(), FOO_ARGUMENT, DataObjectModification.ModificationType.WRITE);
    }

    private void createAndVerifyTop(EventCapturingListener<Top> listener) throws Exception {
        this.putTx(TOP_PATH, TOP_INITIAL_DATA).commit().get();
        Collection<DataTreeModification<Top>> events = listener.nextEvent();
        Assert.assertFalse((String)"Non empty collection should be received.", (boolean)events.isEmpty());
        DataTreeModification initialWrite = (DataTreeModification)Iterables.getOnlyElement(events);
        DataObjectModification initialNode = initialWrite.getRootNode();
        DataTreeChangeListenerTest.verifyModification((DataObjectModification<? extends DataObject>)initialNode, (InstanceIdentifier.PathArgument)TOP_PATH.getPathArguments().iterator().next(), DataObjectModification.ModificationType.WRITE);
        Assert.assertEquals((Object)TOP_INITIAL_DATA, (Object)initialNode.getDataAfter());
    }

    private static void verifyModification(DataObjectModification<? extends DataObject> barWrite, InstanceIdentifier.PathArgument pathArg, DataObjectModification.ModificationType eventType) {
        Assert.assertEquals((Object)pathArg.getType(), (Object)barWrite.getDataType());
        Assert.assertEquals((Object)eventType, (Object)barWrite.getModificationType());
        Assert.assertEquals((Object)pathArg, (Object)barWrite.getIdentifier());
    }

    private <T extends DataObject> WriteTransaction putTx(InstanceIdentifier<T> path, T data) {
        WriteTransaction tx = this.dataBrokerImpl.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, path, data);
        return tx;
    }

    private WriteTransaction deleteTx(InstanceIdentifier<?> path) {
        WriteTransaction tx = this.dataBrokerImpl.newWriteOnlyTransaction();
        tx.delete(LogicalDatastoreType.OPERATIONAL, path);
        return tx;
    }

    private static final class EventCapturingListener<T extends DataObject>
    implements DataTreeChangeListener<T> {
        private SettableFuture<Collection<DataTreeModification<T>>> futureChanges = SettableFuture.create();

        private EventCapturingListener() {
        }

        public void onDataTreeChanged(Collection<DataTreeModification<T>> changes) {
            this.futureChanges.set(changes);
        }

        Collection<DataTreeModification<T>> nextEvent() throws Exception {
            Collection result = (Collection)this.futureChanges.get(200L, TimeUnit.MILLISECONDS);
            this.futureChanges = SettableFuture.create();
            return result;
        }
    }
}

