/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Collection;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataBrokerTest;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.ListenerTest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.ListenerTestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItem;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItemBuilder;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Uint32;

public class Bug4513Test
extends AbstractDataBrokerTest {
    @Test
    public void testDataTreeChangeListener() {
        DataBroker dataBroker = this.getDataBroker();
        DataTreeChangeListener listener = (DataTreeChangeListener)Mockito.mock(DataTreeChangeListener.class);
        InstanceIdentifier wildCard = InstanceIdentifier.builder(ListenerTest.class).child(ListItem.class).build();
        ListenerRegistration reg = dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)wildCard), listener);
        ListItem item = this.writeListItem();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Collection.class);
        ((DataTreeChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)100L))).onDataTreeChanged((Collection)captor.capture());
        Collection mods = (Collection)captor.getValue();
        Assert.assertEquals((String)"ListItem", (Object)item, (Object)((DataTreeModification)mods.iterator().next()).getRootNode().getDataAfter());
    }

    private ListItem writeListItem() {
        WriteTransaction writeTransaction = this.getDataBroker().newWriteOnlyTransaction();
        ListItem item = new ListItemBuilder().setSip("name").setOp(Uint32.valueOf((int)43)).build();
        ListenerTestBuilder builder = new ListenerTestBuilder().setListItem(Map.of(item.key(), item));
        writeTransaction.put(LogicalDatastoreType.OPERATIONAL, InstanceIdentifier.builder(ListenerTest.class).build(), (DataObject)builder.build());
        Bug4513Test.assertCommit(writeTransaction.commit());
        return item;
    }
}

