/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataTreeChangeListenerTest;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.Root;
import org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.RootBuilder;
import org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root.Fooroot;
import org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root.FoorootBuilder;
import org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root.fooroot.Barroot;
import org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root.fooroot.BarrootBuilder;
import org.opendaylight.yang.gen.v1.opendaylight.test.bug._2562.namespace.rev160101.root.fooroot.BarrootKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

public class Bug2562DeserializedUnkeyedListTest
extends AbstractDataTreeChangeListenerTest {
    private static final InstanceIdentifier<Root> ROOT_PATH = InstanceIdentifier.create(Root.class);

    @Override
    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return ImmutableSet.of((Object)BindingReflections.getModuleInfo(Root.class));
    }

    @Test
    public void writeListToList2562Root() {
        Barroot barRoot = new BarrootBuilder().setType(Integer.valueOf(2)).setValue(Integer.valueOf(2)).withKey(new BarrootKey(Integer.valueOf(2))).build();
        Fooroot fooRoot = new FoorootBuilder().setBarroot(Map.of(barRoot.key(), barRoot)).build();
        Root root = new RootBuilder().setFooroot(Arrays.asList(fooRoot)).build();
        AbstractDataTreeChangeListenerTest.TestListener<Root> listenerRoot = this.createListener(LogicalDatastoreType.CONFIGURATION, ROOT_PATH, Bug2562DeserializedUnkeyedListTest.added(ROOT_PATH, root));
        ReadWriteTransaction readWriteTransaction = this.getDataBroker().newReadWriteTransaction();
        readWriteTransaction.put(LogicalDatastoreType.CONFIGURATION, ROOT_PATH, (DataObject)root);
        Bug2562DeserializedUnkeyedListTest.assertCommit(readWriteTransaction.commit());
        listenerRoot.verify();
    }
}

